/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import java.util.List;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.PredicateFactory;
import org.apache.camel.builder.LanguageBuilder;
import org.apache.camel.model.HasExpressionType;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.spi.ExpressionFactoryAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PredicateFactoryAware;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="language", title="Expression")
@XmlRootElement
@XmlType(name="expression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionDefinition
implements Expression,
Predicate,
ExpressionFactory,
ExpressionFactoryAware,
PredicateFactory,
PredicateFactoryAware,
HasExpressionType {
    @XmlTransient
    private Predicate predicate;
    @XmlTransient
    private Expression expressionValue;
    @XmlTransient
    private ExpressionDefinition expressionType;
    @XmlAttribute
    @XmlID
    private String id;
    @XmlValue
    @Metadata(required=true)
    private String expression;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String trim;

    public ExpressionDefinition() {
    }

    public ExpressionDefinition(String expression) {
        this.expression = expression;
    }

    public ExpressionDefinition(Predicate predicate) {
        this.predicate = predicate;
    }

    public ExpressionDefinition(Expression expression) {
        this.expressionValue = expression;
    }

    protected ExpressionDefinition(AbstractBuilder<?, ?> builder) {
        this.id = builder.id;
        this.expression = builder.expression;
        this.trim = builder.trim;
        this.predicate = builder.predicate;
    }

    public static String getLabel(List<ExpressionDefinition> expressions) {
        StringJoiner buffer = new StringJoiner(", ");
        for (ExpressionDefinition expression : expressions) {
            buffer.add(expression.getLabel());
        }
        return buffer.toString();
    }

    public String toString() {
        if (this.getExpressionValue() != null) {
            return this.getExpressionValue().toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.getLanguage() != null) {
            sb.append(this.getLanguage()).append("{");
        }
        if (this.getPredicate() != null) {
            sb.append(this.getPredicate().toString());
        } else if (this.getExpression() != null) {
            sb.append(this.getExpression());
        }
        if (this.getLanguage() != null) {
            sb.append("}");
        }
        return sb.toString();
    }

    public String getLanguage() {
        return "";
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    protected void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    @Override
    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    @Override
    public void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    public String getTrim() {
        return this.trim;
    }

    public void setTrim(String trim) {
        this.trim = trim;
    }

    public String getLabel() {
        Predicate predicate = this.getPredicate();
        if (predicate != null) {
            return predicate.toString();
        }
        Expression expressionValue = this.getExpressionValue();
        if (expressionValue != null) {
            return expressionValue.toString();
        }
        String exp = this.getExpression();
        return exp != null ? exp : "";
    }

    public ExpressionFactory getExpressionFactory() {
        return this;
    }

    public PredicateFactory getPredicateFactory() {
        return this;
    }

    public Expression createExpression(CamelContext camelContext) {
        return ((ModelCamelContext)camelContext.adapt(ModelCamelContext.class)).createExpression(this);
    }

    public Predicate createPredicate(CamelContext camelContext) {
        return ((ModelCamelContext)camelContext.adapt(ModelCamelContext.class)).createPredicate(this);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expressionValue == null) {
            this.expressionValue = this.createExpression(exchange.getContext());
        }
        ObjectHelper.notNull((Object)this.expressionValue, (String)"expressionValue");
        return (T)this.expressionValue.evaluate(exchange, type);
    }

    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange.getContext());
        }
        ObjectHelper.notNull((Object)this.predicate, (String)"predicate");
        return this.predicate.matches(exchange);
    }

    public void init(CamelContext context) {
        if (this.expressionValue == null) {
            this.expressionValue = this.createExpression(context);
        }
        if (this.predicate == null) {
            this.predicate = this.createPredicate(context);
        }
    }

    public void initPredicate(CamelContext context) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(context);
        }
    }

    @XmlTransient
    static abstract class AbstractBuilder<T extends AbstractBuilder<T, E>, E extends ExpressionDefinition>
    implements LanguageBuilder<E> {
        private String id;
        private String expression;
        private String trim;
        private Predicate predicate;

        AbstractBuilder() {
        }

        public T id(String id) {
            this.id = id;
            return (T)this;
        }

        public T trim(String trim) {
            this.trim = trim;
            return (T)this;
        }

        public T trim(boolean trim) {
            this.trim = Boolean.toString(trim);
            return (T)this;
        }

        public T expression(String expression) {
            this.expression = expression;
            return (T)this;
        }

        public T predicate(Predicate predicate) {
            this.predicate = predicate;
            return (T)this;
        }
    }
}

