/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.model.ErrorHandlerDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.PreconditionContainer;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="routeConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteConfigurationDefinition
extends OptionalIdentifiedDefinition<RouteConfigurationDefinition>
implements PreconditionContainer {
    @XmlElement
    private ErrorHandlerDefinition errorHandler;
    @XmlElement(name="intercept")
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom")
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint")
    private List<InterceptSendToEndpointDefinition> interceptSendTos = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="onException")
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion")
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlAttribute
    @Metadata(label="advanced")
    private String precondition;

    public String toString() {
        return "RoutesConfiguration: " + this.getId();
    }

    public String getShortName() {
        return "routesConfiguration";
    }

    public String getLabel() {
        return "RoutesConfiguration " + this.getId();
    }

    public ErrorHandlerDefinition getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerDefinition errorHandler) {
        this.errorHandler = errorHandler;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendTos() {
        return this.interceptSendTos;
    }

    public void setInterceptSendTos(List<InterceptSendToEndpointDefinition> interceptSendTos) {
        this.interceptSendTos = interceptSendTos;
    }

    @Override
    public String getPrecondition() {
        return this.precondition;
    }

    @Override
    public void setPrecondition(String precondition) {
        this.precondition = precondition;
    }

    public RouteConfigurationDefinition errorHandler(String ref) {
        ErrorHandlerDefinition def = new ErrorHandlerDefinition();
        def.setErrorHandlerType(new RefErrorHandlerDefinition(ref));
        this.setErrorHandler(def);
        return this;
    }

    public RouteConfigurationDefinition errorHandler(ErrorHandlerFactory errorHandler) {
        ErrorHandlerDefinition def = new ErrorHandlerDefinition();
        def.setErrorHandlerType(errorHandler);
        this.setErrorHandler(def);
        return this;
    }

    public RouteConfigurationDefinition precondition(String precondition) {
        this.setPrecondition(precondition);
        return this;
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exceptionType) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exceptionType);
        answer.setRouteConfiguration(this);
        this.onExceptions.add(answer);
        return answer;
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition answer = new OnExceptionDefinition(Arrays.asList(exceptions));
        answer.setRouteConfiguration(this);
        this.onExceptions.add(answer);
        return answer;
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        answer.setRouteConfiguration(this);
        answer.setRouteScoped(false);
        this.onCompletions.add(answer);
        return answer;
    }

    public InterceptDefinition intercept() {
        InterceptDefinition answer = new InterceptDefinition();
        answer.setRouteConfiguration(this);
        this.intercepts.add(answer);
        return answer;
    }

    public InterceptFromDefinition interceptFrom() {
        InterceptFromDefinition answer = new InterceptFromDefinition();
        answer.setRouteConfiguration(this);
        this.interceptFroms.add(answer);
        return answer;
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        InterceptFromDefinition answer = new InterceptFromDefinition(uri);
        answer.setRouteConfiguration(this);
        this.interceptFroms.add(answer);
        return answer;
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        InterceptSendToEndpointDefinition answer = new InterceptSendToEndpointDefinition(uri);
        answer.setRouteConfiguration(this);
        this.interceptSendTos.add(answer);
        return answer;
    }
}

