/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.base;

import java.util.Map;
import org.apache.camel.CamelException;
import org.apache.camel.spi.HttpResponseAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class HttpOperationFailedException
extends CamelException
implements HttpResponseAware {
    private static final long serialVersionUID = -8721487434390572634L;
    private final String uri;
    private final String redirectLocation;
    private final int statusCode;
    private final String statusText;
    private final Map<String, String> responseHeaders;
    private final String responseBody;

    public HttpOperationFailedException(String uri, int statusCode, String statusText, String location, Map<String, String> responseHeaders, String responseBody) {
        super("HTTP operation failed invoking " + URISupport.sanitizeUri((String)uri) + " with statusCode: " + statusCode + (String)(location != null ? ", redirectLocation: " + location : ""));
        this.uri = URISupport.sanitizeUri((String)uri);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.redirectLocation = location;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isRedirectError() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasRedirectLocation() {
        return ObjectHelper.isNotEmpty((String)this.redirectLocation);
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getHttpResponseCode() {
        return this.statusCode;
    }

    public void setHttpResponseCode(int code) {
        throw new UnsupportedOperationException();
    }

    public String getHttpResponseStatus() {
        return this.statusText;
    }

    public void setHttpResponseStatus(String status) {
        throw new UnsupportedOperationException();
    }
}

