/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class Kamelet {
    public static final String PROPERTIES_PREFIX = "camel.kamelet.";
    public static final String SCHEME = "kamelet";
    public static final String SOURCE_ID = "source";
    public static final String SINK_ID = "sink";
    public static final String PARAM_ROUTE_ID = "routeId";
    public static final String PARAM_TEMPLATE_ID = "templateId";
    public static final String PARAM_LOCATION = "location";
    public static final String DEFAULT_LOCATION = "classpath:/kamelets";
    private static final UuidGenerator UUID = new SimpleUuidGenerator();

    private Kamelet() {
    }

    public static Predicate<String> startsWith(String prefix) {
        return item -> item.startsWith(prefix);
    }

    public static String extractTemplateId(CamelContext context, String remaining, Map<String, Object> parameters) {
        Object param = parameters.get(PARAM_TEMPLATE_ID);
        if (param != null) {
            return (String)CamelContextHelper.mandatoryConvertTo((CamelContext)context, String.class, (Object)param);
        }
        if (SOURCE_ID.equals(remaining) || SINK_ID.equals(remaining)) {
            return context.resolvePropertyPlaceholders("{{templateId}}");
        }
        String answer = null;
        if (remaining != null) {
            answer = StringHelper.before((String)remaining, (String)"/");
        }
        if (answer == null) {
            answer = remaining;
        }
        return answer;
    }

    public static String extractRouteId(CamelContext context, String remaining, Map<String, Object> parameters) {
        Object param = parameters.get(PARAM_ROUTE_ID);
        if (param != null) {
            return (String)CamelContextHelper.mandatoryConvertTo((CamelContext)context, String.class, (Object)param);
        }
        if (SOURCE_ID.equals(remaining) || SINK_ID.equals(remaining)) {
            return context.resolvePropertyPlaceholders("{{routeId}}");
        }
        Object answer = null;
        if (remaining != null) {
            answer = StringHelper.after((String)remaining, (String)"/");
        }
        if (answer == null) {
            answer = Kamelet.extractTemplateId(context, remaining, parameters) + "-" + UUID.generateUuid();
        }
        return answer;
    }

    public static String extractLocation(CamelContext context, Map<String, Object> parameters) {
        Object param = parameters.get(PARAM_LOCATION);
        if (param != null) {
            return (String)CamelContextHelper.mandatoryConvertTo((CamelContext)context, String.class, (Object)param);
        }
        return null;
    }

    public static void extractKameletProperties(CamelContext context, Map<String, Object> properties, String ... elements) {
        PropertiesComponent pc = context.getPropertiesComponent();
        StringBuffer prefixBuffer = new StringBuffer(PROPERTIES_PREFIX);
        for (String element : elements) {
            if (element == null) continue;
            prefixBuffer.append(element + ".");
            Properties prefixed = pc.loadProperties(Kamelet.startsWith(prefixBuffer.toString()));
            for (String name : prefixed.stringPropertyNames()) {
                properties.put(name.substring(prefixBuffer.toString().length()), prefixed.getProperty(name));
            }
        }
    }

    public static RouteDefinition templateToRoute(RouteTemplateDefinition in, Map<String, Object> parameters) {
        String rid = (String)parameters.get(PARAM_ROUTE_ID);
        ObjectHelper.notNull((Object)rid, (String)PARAM_ROUTE_ID);
        RouteDefinition def = in.asRouteDefinition();
        def.setLocation(in.getLocation());
        def.setLineNumber(in.getLineNumber());
        def.setId(rid);
        if (def.getInput() == null) {
            throw new IllegalArgumentException("Camel route " + rid + " input does not exist.");
        }
        if (def.getInput().getEndpointUri().startsWith("kamelet:source") || def.getInput().getEndpointUri().startsWith("kamelet://source")) {
            def.getInput().setUri("kamelet://source?routeId=" + rid);
        }
        int line = -1;
        boolean sink = false;
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)def.getOutputs(), ToDefinition.class);
        for (ToDefinition to : col) {
            if (to.getEndpointUri().startsWith("kamelet:sink") || to.getEndpointUri().startsWith("kamelet://sink")) {
                to.setUri("kamelet://sink?routeId=" + rid);
                sink = true;
            }
            line = to.getLineNumber();
        }
        if (!sink) {
            ToDefinition to = new ToDefinition("kamelet://sink?routeId=" + rid);
            to.setLocation(def.getInput().getLocation());
            if (line != -1) {
                to.setLineNumber(line + 1);
            }
            def.getOutputs().add(to);
        }
        return def;
    }
}

