/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.apache.camel.support.task.AbstractTaskBuilder;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.budget.TimeBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTask
implements BlockingTask {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTask.class);
    private final TimeBudget budget;
    private final ScheduledExecutorService service;
    private final String name;
    private Duration elapsed = Duration.ZERO;

    BackgroundTask(TimeBudget budget, ScheduledExecutorService service, String name) {
        this.budget = budget;
        this.service = Objects.requireNonNull(service);
        this.name = name;
    }

    private <T> void runTaskWrapper(CountDownLatch latch, Predicate<T> predicate, T payload) {
        LOG.trace("Current latch value: {}", (Object)latch.getCount());
        if (latch.getCount() == 0L) {
            return;
        }
        if (!this.budget.next()) {
            LOG.warn("The task {} does not have more budget to continue running", (Object)this.name);
            return;
        }
        if (predicate.test(payload)) {
            latch.countDown();
            LOG.trace("Task {} has succeeded and the current task won't be schedulable anymore: {}", (Object)this.name, (Object)latch.getCount());
        }
    }

    private void runTaskWrapper(CountDownLatch latch, BooleanSupplier supplier) {
        LOG.trace("Current latch value: {}", (Object)latch.getCount());
        if (latch.getCount() == 0L) {
            return;
        }
        if (!this.budget.next()) {
            LOG.warn("The task {} does not have more budget to continue running", (Object)this.name);
            return;
        }
        if (supplier.getAsBoolean()) {
            latch.countDown();
            LOG.trace("Task {} succeeded and the current task won't be schedulable anymore: {}", (Object)this.name, (Object)latch.getCount());
        }
    }

    @Override
    public <T> boolean run(Predicate<T> predicate, T payload) {
        CountDownLatch latch = new CountDownLatch(1);
        this.service.scheduleAtFixedRate(() -> this.runTaskWrapper(latch, predicate, payload), this.budget.initialDelay(), this.budget.interval(), TimeUnit.MILLISECONDS);
        return this.waitForTaskCompletion(latch, this.service);
    }

    @Override
    public boolean run(BooleanSupplier supplier) {
        CountDownLatch latch = new CountDownLatch(1);
        this.service.scheduleAtFixedRate(() -> this.runTaskWrapper(latch, supplier), this.budget.initialDelay(), this.budget.interval(), TimeUnit.MILLISECONDS);
        return this.waitForTaskCompletion(latch, this.service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForTaskCompletion(CountDownLatch latch, ScheduledExecutorService service) {
        boolean completed = false;
        try {
            if (this.budget.maxDuration() == -1L) {
                latch.await();
                completed = true;
            } else if (!latch.await(this.budget.maxDuration(), TimeUnit.MILLISECONDS)) {
                LOG.debug("Timeout out waiting for the completion of the task");
            } else {
                LOG.debug("The task has finished the execution and it is ready to continue");
                completed = true;
            }
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the repeatable task to execute");
            Thread.currentThread().interrupt();
        }
        finally {
            this.elapsed = this.budget.elapsed();
            service.shutdownNow();
        }
        return completed;
    }

    @Override
    public Duration elapsed() {
        return this.elapsed;
    }

    public static class BackgroundTaskBuilder
    extends AbstractTaskBuilder<BackgroundTask> {
        private TimeBudget budget;
        private ScheduledExecutorService service;

        public BackgroundTaskBuilder withBudget(TimeBudget timeBudget) {
            this.budget = timeBudget;
            return this;
        }

        public BackgroundTaskBuilder withScheduledExecutor(ScheduledExecutorService service) {
            this.service = service;
            return this;
        }

        @Override
        public BackgroundTask build() {
            return new BackgroundTask(this.budget, this.service, this.getName());
        }
    }
}

