/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CxfRsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":beanId:address";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "cxfrs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "beanId", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "address", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(34);
        props.add("bindingStyle");
        props.add("basicPropertyBinding");
        props.add("bus");
        props.add("resourceClasses");
        props.add("synchronous");
        props.add("cxfRsConfigurer");
        props.add("hostnameVerifier");
        props.add("sslContextParameters");
        props.add("httpClientAPI");
        props.add("binding");
        props.add("schemaLocations");
        props.add("defaultBus");
        props.add("features");
        props.add("bridgeErrorHandler");
        props.add("headerFilterStrategy");
        props.add("loggingSizeLimit");
        props.add("serviceBeans");
        props.add("beanId");
        props.add("ignoreDeleteMethodMessageBody");
        props.add("performInvocation");
        props.add("address");
        props.add("skipFaultLogging");
        props.add("throwExceptionOnFailure");
        props.add("propagateContexts");
        props.add("continuationTimeout");
        props.add("exchangePattern");
        props.add("loggingFeatureEnabled");
        props.add("modelRef");
        props.add("lazyStartProducer");
        props.add("publishedEndpointUrl");
        props.add("cookieHandler");
        props.add("exceptionHandler");
        props.add("providers");
        props.add("maxClientCacheSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

