/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupListener;
import org.apache.camel.impl.engine.DefaultRouteController;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSupervisingRouteController
extends DefaultRouteController
implements SupervisingRouteController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSupervisingRouteController.class);
    private final Object lock = new Object();
    private final AtomicBoolean contextStarted = new AtomicBoolean(false);
    private final AtomicInteger routeCount = new AtomicInteger(0);
    private final Set<RouteHolder> routes = new TreeSet<RouteHolder>();
    private final Set<String> nonSupervisedRoutes = new HashSet<String>();
    private final RouteManager routeManager = new RouteManager();
    private volatile CamelContextStartupListener listener;
    private volatile BackOffTimer timer;
    private volatile ScheduledExecutorService executorService;
    private volatile BackOff backOff;
    private String includeRoutes;
    private String excludeRoutes;
    private int threadPoolSize = 1;
    private long initialDelay;
    private long backOffDelay = 2000L;
    private long backOffMaxDelay;
    private long backOffMaxElapsedTime;
    private long backOffMaxAttempts;
    private double backOffMultiplier = 1.0;

    public String getIncludeRoutes() {
        return this.includeRoutes;
    }

    public void setIncludeRoutes(String includeRoutes) {
        this.includeRoutes = includeRoutes;
    }

    public String getExcludeRoutes() {
        return this.excludeRoutes;
    }

    public void setExcludeRoutes(String excludeRoutes) {
        this.excludeRoutes = excludeRoutes;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getBackOffDelay() {
        return this.backOffDelay;
    }

    public void setBackOffDelay(long backOffDelay) {
        this.backOffDelay = backOffDelay;
    }

    public long getBackOffMaxDelay() {
        return this.backOffMaxDelay;
    }

    public void setBackOffMaxDelay(long backOffMaxDelay) {
        this.backOffMaxDelay = backOffMaxDelay;
    }

    public long getBackOffMaxElapsedTime() {
        return this.backOffMaxElapsedTime;
    }

    public void setBackOffMaxElapsedTime(long backOffMaxElapsedTime) {
        this.backOffMaxElapsedTime = backOffMaxElapsedTime;
    }

    public long getBackOffMaxAttempts() {
        return this.backOffMaxAttempts;
    }

    public void setBackOffMaxAttempts(long backOffMaxAttempts) {
        this.backOffMaxAttempts = backOffMaxAttempts;
    }

    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    protected BackOff getBackOff(String id) {
        return this.backOff;
    }

    protected void doInit() throws Exception {
        this.backOff = new BackOff(Duration.ofMillis(this.backOffDelay), this.backOffMaxDelay > 0L ? Duration.ofMillis(this.backOffMaxDelay) : Duration.ofMillis(Long.MAX_VALUE), this.backOffMaxElapsedTime > 0L ? Duration.ofMillis(this.backOffMaxElapsedTime) : Duration.ofMillis(Long.MAX_VALUE), Long.valueOf(this.backOffMaxAttempts > 0L ? this.backOffMaxAttempts : Long.MAX_VALUE), Double.valueOf(this.backOffMultiplier));
        this.listener = new CamelContextStartupListener();
        CamelContext context = this.getCamelContext();
        context.setAutoStartup(Boolean.valueOf(false));
        context.addRoutePolicyFactory((RoutePolicyFactory)new ManagedRoutePolicyFactory());
        context.addStartupListener((StartupListener)this.listener);
    }

    protected void doStart() throws Exception {
        CamelContext context = this.getCamelContext();
        this.executorService = this.threadPoolSize == 1 ? context.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "SupervisingRouteController") : context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "SupervisingRouteController", this.threadPoolSize);
        this.timer = new BackOffTimer(this.executorService);
    }

    protected void doStop() throws Exception {
        if (this.getCamelContext() != null && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.executorService);
            this.executorService = null;
            this.timer = null;
        }
    }

    @Override
    public void startRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.startRoute(routeId);
        } else {
            this.doStartRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> super.startRoute(routeId)));
        }
    }

    @Override
    public void stopRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.stopRoute(routeId);
        } else {
            this.doStopRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> super.stopRoute(routeId)));
        }
    }

    @Override
    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.stopRoute(routeId, timeout, timeUnit);
        } else {
            this.doStopRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> super.stopRoute(r.getId(), timeout, timeUnit)));
        }
    }

    @Override
    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            return super.stopRoute(routeId, timeout, timeUnit, abortAfterTimeout);
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.doStopRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> result.set(super.stopRoute(r.getId(), timeout, timeUnit, abortAfterTimeout))));
        return result.get();
    }

    @Override
    public void suspendRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.suspendRoute(routeId);
        } else {
            this.doStopRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> super.suspendRoute(r.getId())));
        }
    }

    @Override
    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.suspendRoute(routeId, timeout, timeUnit);
        } else {
            this.doStopRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> super.suspendRoute(r.getId(), timeout, timeUnit)));
        }
    }

    @Override
    public void resumeRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.resumeRoute(routeId);
        } else {
            this.doStartRoute(route.get(), true, (ThrowingConsumer<RouteHolder, Exception>)((ThrowingConsumer)r -> super.startRoute(routeId)));
        }
    }

    @Override
    public Collection<Route> getControlledRoutes() {
        return this.routes.stream().map(RouteHolder::get).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopRoute(RouteHolder route, boolean checker, ThrowingConsumer<RouteHolder, Exception> consumer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (checker) {
                this.routeManager.release(route);
            }
            LOG.debug("Route {} has been requested to stop", (Object)route.getId());
            route.get().setRouteController(null);
            consumer.accept((Object)route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartRoute(RouteHolder route, boolean checker, ThrowingConsumer<RouteHolder, Exception> consumer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            route.get().setRouteController((RouteController)this);
            try {
                if (checker) {
                    this.routeManager.release(route);
                }
                consumer.accept((Object)route);
            }
            catch (Exception e) {
                if (checker) {
                    this.routeManager.start(route);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNonSupervisedRoutes() throws Exception {
        List routeList;
        if (!this.isRunAllowed()) {
            return;
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            routeList = this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Stopped).filter(r -> !this.isSupervised(((RouteHolder)r).route)).map(RouteHolder::getId).collect(Collectors.toList());
        }
        for (String route : routeList) {
            try {
                LOG.debug("Starting non-supervised route {}", (Object)route);
                super.startRoute(route);
            }
            catch (Exception e) {
                throw new FailedToStartRouteException(route, e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSupervisedRoutes() {
        List routeList;
        if (!this.isRunAllowed()) {
            return;
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            routeList = this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Stopped).filter(r -> this.isSupervised(((RouteHolder)r).route)).map(RouteHolder::getId).collect(Collectors.toList());
        }
        LOG.debug("Starting {} supervised routes", (Object)routeList.size());
        for (String route : routeList) {
            try {
                this.startRoute(route);
            }
            catch (Exception exception) {}
        }
        LOG.info("Total managed routes: {} of which {} successfully started and {} re-starting", new Object[]{this.routes.size(), this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Started).count(), this.routeManager.routes.size()});
    }

    private boolean isSupervised(Route route) {
        return !this.nonSupervisedRoutes.contains(route.getId());
    }

    private class CamelContextStartupListener
    implements ExtendedStartupListener {
        private CamelContextStartupListener() {
        }

        public void onCamelContextStarting(CamelContext context, boolean alreadyStarted) throws Exception {
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        }

        public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            if (alreadyStarted) {
                this.onCamelContextStarted();
            }
        }

        private void onCamelContextStarted() throws Exception {
            if (DefaultSupervisingRouteController.this.contextStarted.compareAndSet(false, true)) {
                DefaultSupervisingRouteController.this.startNonSupervisedRoutes();
                if (DefaultSupervisingRouteController.this.initialDelay > 0L) {
                    LOG.debug("Supervised routes will be started in {} millis", (Object)DefaultSupervisingRouteController.this.initialDelay);
                    DefaultSupervisingRouteController.this.executorService.schedule(() -> DefaultSupervisingRouteController.this.startSupervisedRoutes(), DefaultSupervisingRouteController.this.initialDelay, TimeUnit.MILLISECONDS);
                } else {
                    DefaultSupervisingRouteController.this.startSupervisedRoutes();
                }
            }
        }
    }

    private class ManagedRoutePolicy
    extends RoutePolicySupport {
        private ManagedRoutePolicy() {
        }

        private void startRoute(RouteHolder holder) {
            try {
                DefaultSupervisingRouteController.this.doStartRoute(holder, true, (ThrowingConsumer<RouteHolder, Exception>)r -> DefaultSupervisingRouteController.super.startRoute(r.getId()));
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }

        public void onInit(Route route) {
            if (!route.isAutoStartup().booleanValue()) {
                LOG.info("Route: {} will not be supervised (Reason: has explicit auto-startup flag set to false)", (Object)route.getId());
                return;
            }
            if (DefaultSupervisingRouteController.this.excludeRoutes != null) {
                for (String part : DefaultSupervisingRouteController.this.excludeRoutes.split(",")) {
                    boolean exclude;
                    String id = route.getRouteId();
                    String uri = route.getEndpoint().getEndpointUri();
                    boolean bl = exclude = PatternHelper.matchPattern((String)id, (String)part) || PatternHelper.matchPattern((String)uri, (String)part);
                    if (!exclude) continue;
                    LOG.debug("Route: {} excluded from being supervised", (Object)route.getId());
                    RouteHolder holder = new RouteHolder(route, DefaultSupervisingRouteController.this.routeCount.incrementAndGet());
                    if (DefaultSupervisingRouteController.this.routes.add(holder)) {
                        DefaultSupervisingRouteController.this.nonSupervisedRoutes.add(route.getId());
                        holder.get().setRouteController((RouteController)DefaultSupervisingRouteController.this);
                        holder.get().setAutoStartup(Boolean.valueOf(true));
                    }
                    return;
                }
            }
            if (DefaultSupervisingRouteController.this.includeRoutes != null) {
                boolean include = false;
                for (String part : DefaultSupervisingRouteController.this.includeRoutes.split(",")) {
                    String id = route.getRouteId();
                    String uri = route.getEndpoint().getEndpointUri();
                    boolean bl = include = PatternHelper.matchPattern((String)id, (String)part) || PatternHelper.matchPattern((String)uri, (String)part);
                    if (include) break;
                }
                if (!include) {
                    LOG.debug("Route: {} excluded from being supervised", (Object)route.getId());
                    RouteHolder holder = new RouteHolder(route, DefaultSupervisingRouteController.this.routeCount.incrementAndGet());
                    if (DefaultSupervisingRouteController.this.routes.add(holder)) {
                        DefaultSupervisingRouteController.this.nonSupervisedRoutes.add(route.getId());
                        holder.get().setRouteController((RouteController)DefaultSupervisingRouteController.this);
                        holder.get().setAutoStartup(Boolean.valueOf(true));
                    }
                    return;
                }
            }
            RouteHolder holder = new RouteHolder(route, DefaultSupervisingRouteController.this.routeCount.incrementAndGet());
            if (DefaultSupervisingRouteController.this.routes.add(holder)) {
                holder.get().setRouteController((RouteController)DefaultSupervisingRouteController.this);
                holder.get().setAutoStartup(Boolean.valueOf(false));
                if (DefaultSupervisingRouteController.this.contextStarted.get()) {
                    LOG.debug("Context is already started: attempt to start route {}", (Object)route.getId());
                    if (DefaultSupervisingRouteController.this.initialDelay > 0L) {
                        LOG.debug("Route {} will be started in {} millis", (Object)holder.getId(), (Object)DefaultSupervisingRouteController.this.initialDelay);
                        DefaultSupervisingRouteController.this.executorService.schedule(() -> this.startRoute(holder), DefaultSupervisingRouteController.this.initialDelay, TimeUnit.MILLISECONDS);
                    } else {
                        this.startRoute(holder);
                    }
                } else {
                    LOG.debug("CamelContext is not yet started. Deferring staring route: {}", (Object)holder.getId());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemove(Route route) {
            Object object = this.lock;
            synchronized (object) {
                DefaultSupervisingRouteController.this.routes.removeIf(r -> ObjectHelper.equal((Object)r.get(), (Object)route) || ObjectHelper.equal((Object)r.getId(), (Object)route.getId()));
            }
        }
    }

    private class ManagedRoutePolicyFactory
    implements RoutePolicyFactory {
        private final RoutePolicy policy;

        private ManagedRoutePolicyFactory() {
            this.policy = new ManagedRoutePolicy();
        }

        public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
            return this.policy;
        }
    }

    private static class RouteHolder
    implements HasId,
    Comparable<RouteHolder> {
        private final int order;
        private final Route route;

        RouteHolder(Route route, int order) {
            this.route = route;
            this.order = order;
        }

        public String getId() {
            return this.route.getId();
        }

        public Route get() {
            return this.route;
        }

        public ServiceStatus getStatus() {
            return this.route.getCamelContext().getRouteController().getRouteStatus(this.getId());
        }

        int getInitializationOrder() {
            return this.order;
        }

        public int getStartupOrder() {
            Integer order = this.route.getStartupOrder();
            if (order == null) {
                order = Integer.MAX_VALUE;
            }
            return order;
        }

        @Override
        public int compareTo(RouteHolder o) {
            int answer = Integer.compare(this.getStartupOrder(), o.getStartupOrder());
            if (answer == 0) {
                answer = Integer.compare(this.getInitializationOrder(), o.getInitializationOrder());
            }
            return answer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.route.equals(((RouteHolder)o).route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }
    }

    private class RouteManager {
        private final Logger logger = LoggerFactory.getLogger(RouteManager.class);
        private final ConcurrentMap<RouteHolder, BackOffTimer.Task> routes = new ConcurrentHashMap<RouteHolder, BackOffTimer.Task>();

        RouteManager() {
        }

        void start(RouteHolder route) {
            route.get().setRouteController((RouteController)DefaultSupervisingRouteController.this);
            this.routes.computeIfAbsent(route, r -> {
                BackOff backOff = DefaultSupervisingRouteController.this.getBackOff(r.getId());
                this.logger.info("Start supervising route: {} with back-off: {}", (Object)r.getId(), (Object)backOff);
                BackOffTimer.Task task = DefaultSupervisingRouteController.this.timer.schedule(backOff, context -> {
                    BackOffTimer.Task state = this.getBackOffContext(r.getId()).orElse(null);
                    long attempt = state != null ? state.getCurrentAttempts() : 0L;
                    try {
                        this.logger.info("Restarting route: {} attempt: {}", (Object)r.getId(), (Object)attempt);
                        DefaultSupervisingRouteController.this.doStartRoute(r, false, (ThrowingConsumer<RouteHolder, Exception>)rx -> DefaultSupervisingRouteController.super.startRoute(rx.getId()));
                        return false;
                    }
                    catch (Exception e) {
                        String cause = e.getClass().getName() + ": " + e.getMessage();
                        this.logger.info("Failed restarting route: {} attempt: {} due: {} (stacktrace in debug log level)", new Object[]{r.getId(), attempt, cause});
                        this.logger.debug("    Error restarting route caused by: " + e.getMessage(), (Throwable)e);
                        return true;
                    }
                });
                task.whenComplete((backOffTask, throwable) -> {
                    if (backOffTask == null || backOffTask.getStatus() != BackOffTimer.Task.Status.Active) {
                        Object object = DefaultSupervisingRouteController.this.lock;
                        synchronized (object) {
                            boolean stopped;
                            ServiceStatus status = route.getStatus();
                            boolean bl = stopped = status.isStopped() || status.isStopping();
                            if (backOffTask != null && backOffTask.getStatus() == BackOffTimer.Task.Status.Exhausted && stopped) {
                                LOG.warn("Restarting route: {} is exhausted after {} attempts. No more attempts will be made and the route is no longer supervised by this route controller and remains as stopped.", (Object)route.getId(), (Object)(backOffTask.getCurrentAttempts() - 1L));
                                r.get().setRouteController(null);
                            }
                        }
                    }
                    this.routes.remove(r);
                });
                return task;
            });
        }

        boolean release(RouteHolder route) {
            BackOffTimer.Task task = (BackOffTimer.Task)this.routes.remove(route);
            if (task != null) {
                LOG.info("Cancel restart task for route {}", (Object)route.getId());
                task.cancel();
            }
            return task != null;
        }

        public Optional<BackOffTimer.Task> getBackOffContext(String id) {
            return this.routes.entrySet().stream().filter(e -> ObjectHelper.equal((Object)((RouteHolder)e.getKey()).getId(), (Object)id)).findFirst().map(Map.Entry::getValue);
        }
    }
}

