/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import org.apache.camel.Component;
import org.apache.camel.component.cxf.jaxrs.BeanIdAware;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.spring.SpringJAXRSClientFactoryBean;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class CxfRsSpringEndpoint
extends CxfRsEndpoint
implements BeanIdAware {
    private AbstractJAXRSFactoryBean bean;
    private ConfigurerImpl configurer;
    private String beanId;

    public CxfRsSpringEndpoint(Component component, String uri, AbstractJAXRSFactoryBean bean) {
        super(uri, component);
        this.setAddress(bean.getAddress());
        bean.setAddress(this.getAddress());
        this.init(bean);
    }

    private void init(AbstractJAXRSFactoryBean bean) {
        this.bean = bean;
        if (bean instanceof BeanIdAware) {
            this.setBeanId(((BeanIdAware)bean).getBeanId());
        }
        ApplicationContext applicationContext = ((SpringCamelContext)this.getCamelContext()).getApplicationContext();
        this.configurer = new ConfigurerImpl(applicationContext);
    }

    @Override
    protected JAXRSServerFactoryBean newJAXRSServerFactoryBean() {
        this.checkBeanType(this.bean, JAXRSServerFactoryBean.class);
        return (JAXRSServerFactoryBean)this.bean;
    }

    @Override
    protected JAXRSClientFactoryBean newJAXRSClientFactoryBean() {
        this.checkBeanType(this.bean, JAXRSClientFactoryBean.class);
        return this.newInstanceWithCommonProperties();
    }

    @Override
    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        this.configurer.configureBean(this.beanId, (Object)cfb);
        this.getNullSafeCxfRsEndpointConfigurer().configure((AbstractJAXRSFactoryBean)cfb);
        cfb.setAddress(address);
        cfb.setThreadSafe(true);
    }

    @Override
    public String getBeanId() {
        return this.beanId;
    }

    @Override
    public void setBeanId(String id) {
        this.beanId = id;
    }

    private JAXRSClientFactoryBean newInstanceWithCommonProperties() {
        SpringJAXRSClientFactoryBean cfb = new SpringJAXRSClientFactoryBean();
        if (this.bean instanceof SpringJAXRSClientFactoryBean) {
            ReflectionUtils.shallowCopyFieldState((Object)this.bean, (Object)cfb);
        }
        return cfb;
    }
}

