/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cxf.common.CxfPayload;
import org.apache.camel.component.cxf.converter.CachedCxfPayload;
import org.apache.camel.component.cxf.converter.DelegatingXMLStreamReader;
import org.apache.camel.component.cxf.converter.NodeListWrapper;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Converter(generateLoader=true)
public final class CxfPayloadConverter {
    private CxfPayloadConverter() {
    }

    @Converter
    public static <T> CxfPayload<T> documentToCxfPayload(Document doc, Exchange exchange) {
        return CxfPayloadConverter.elementToCxfPayload(doc.getDocumentElement(), exchange);
    }

    @Converter
    public static <T> CxfPayload<T> elementToCxfPayload(Element element, Exchange exchange) {
        ArrayList headers = new ArrayList();
        ArrayList<Element> body = new ArrayList<Element>();
        body.add(element);
        return new CxfPayload(headers, body);
    }

    @Converter
    public static <T> CxfPayload<T> nodeListToCxfPayload(NodeList nodeList, Exchange exchange) {
        ArrayList headers = new ArrayList();
        ArrayList<Element> body = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!Element.class.isAssignableFrom(node.getClass())) continue;
            body.add((Element)node);
        }
        return new CxfPayload(headers, body);
    }

    @Converter
    public static <T> CxfPayload<T> sourceToCxfPayload(Source src, Exchange exchange) {
        ArrayList headers = new ArrayList();
        ArrayList<Source> body = new ArrayList<Source>();
        body.add(src);
        return new CxfPayload(headers, body, null);
    }

    @Converter
    public static <T> NodeList cxfPayloadToNodeList(CxfPayload<T> payload, Exchange exchange) {
        return new NodeListWrapper(payload.getBody());
    }

    @Converter
    public static <T> Node cxfPayLoadToNode(CxfPayload<T> payload, Exchange exchange) {
        List<Element> payloadBodyElements = payload.getBody();
        if (!payloadBodyElements.isEmpty()) {
            return payloadBodyElements.get(0);
        }
        return null;
    }

    @Converter
    public static <T> Source cxfPayLoadToSource(CxfPayload<T> payload, Exchange exchange) {
        List<Source> payloadBody = payload.getBodySources();
        if (!payloadBody.isEmpty()) {
            return payloadBody.get(0);
        }
        return null;
    }

    @Converter
    public static <T> StreamCache cxfPayLoadToStreamCache(CxfPayload<T> payload, Exchange exchange) {
        return new CachedCxfPayload<T>(payload, exchange);
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (type.isAssignableFrom(CxfPayload.class)) {
            try {
                TypeConverter tc;
                if (!value.getClass().isArray()) {
                    Source src = null;
                    if (value instanceof InputStream) {
                        src = new StreamSource((InputStream)value);
                    } else if (value instanceof Reader) {
                        src = new StreamSource((Reader)value);
                    } else if (value instanceof String) {
                        src = new StreamSource(new StringReader((String)value));
                    } else if (value instanceof Node) {
                        src = new DOMSource((Node)value);
                    } else if (value instanceof Source) {
                        src = (Source)value;
                    }
                    if (src == null) {
                        TypeConverter tc2 = registry.lookup(StAXSource.class, value.getClass());
                        if (tc2 == null) {
                            tc2 = registry.lookup(Source.class, value.getClass());
                        }
                        if (tc2 != null) {
                            src = (Source)tc2.convertTo(Source.class, exchange, value);
                        }
                    }
                    if (src != null) {
                        return (T)CxfPayloadConverter.sourceToCxfPayload(src, exchange);
                    }
                }
                if ((tc = registry.lookup(NodeList.class, value.getClass())) != null) {
                    NodeList nodeList = (NodeList)tc.convertTo(NodeList.class, exchange, value);
                    return (T)CxfPayloadConverter.nodeListToCxfPayload(nodeList, exchange);
                }
                tc = registry.lookup(Document.class, value.getClass());
                if (tc != null) {
                    Document document = (Document)tc.convertTo(Document.class, exchange, value);
                    return (T)CxfPayloadConverter.documentToCxfPayload(document, exchange);
                }
                CxfPayload<T> p = CxfPayloadConverter.convertVia(InputStream.class, exchange, value, registry);
                if (p != null) {
                    return (T)p;
                }
                p = CxfPayloadConverter.convertVia(String.class, exchange, value, registry);
                if (p != null) {
                    return (T)p;
                }
            }
            catch (RuntimeCamelException e) {
                return (T)TypeConverter.MISS_VALUE;
            }
            return null;
        }
        if (CxfPayload.class.isAssignableFrom(value.getClass())) {
            TypeConverter tc;
            CxfPayload payload = (CxfPayload)value;
            int size = payload.getBodySources().size();
            if (size == 1) {
                if (type.isAssignableFrom(Document.class)) {
                    Document d;
                    Source s = payload.getBodySources().get(0);
                    try {
                        d = StaxUtils.read((Source)s);
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                    return type.cast(d);
                }
                Source s = payload.getBodySources().get(0);
                if (type.isInstance(s)) {
                    return type.cast(s);
                }
                TypeConverter tc3 = registry.lookup(type, XMLStreamReader.class);
                if (tc3 != null && (s instanceof StaxSource || s instanceof StAXSource)) {
                    XMLStreamReader r;
                    XMLStreamReader xMLStreamReader = r = s instanceof StAXSource ? ((StAXSource)s).getXMLStreamReader() : ((StaxSource)s).getXMLStreamReader();
                    if (payload.getNsMap() != null) {
                        r = new DelegatingXMLStreamReader(r, payload.getNsMap());
                    }
                    return (T)tc3.convertTo(type, exchange, (Object)r);
                }
                tc3 = registry.lookup(type, Source.class);
                if (tc3 != null) {
                    XMLStreamReader r = null;
                    if (payload.getNsMap() != null) {
                        if (s instanceof StaxSource) {
                            r = ((StaxSource)s).getXMLStreamReader();
                        } else if (s instanceof StAXSource) {
                            r = ((StAXSource)s).getXMLStreamReader();
                        }
                        if (r != null) {
                            s = new StAXSource(new DelegatingXMLStreamReader(r, payload.getNsMap()));
                        }
                    }
                    return (T)tc3.convertTo(type, exchange, (Object)s);
                }
            }
            if ((tc = registry.lookup(type, NodeList.class)) != null) {
                Object result = tc.convertTo(type, exchange, (Object)CxfPayloadConverter.cxfPayloadToNodeList((CxfPayload)value, exchange));
                if (result == null) {
                    return (T)TypeConverter.MISS_VALUE;
                }
                return (T)result;
            }
            tc = registry.lookup(type, Node.class);
            if (tc != null) {
                NodeList nodeList = CxfPayloadConverter.cxfPayloadToNodeList((CxfPayload)value, exchange);
                if (nodeList.getLength() > 0) {
                    return (T)tc.convertTo(type, exchange, (Object)nodeList.item(0));
                }
                return (T)TypeConverter.MISS_VALUE;
            }
            if (size == 0) {
                return (T)TypeConverter.MISS_VALUE;
            }
        }
        return null;
    }

    private static <T, V> CxfPayload<T> convertVia(Class<V> via, Exchange exchange, Object value, TypeConverterRegistry registry) {
        TypeConverter tc1;
        TypeConverter tc = registry.lookup(via, value.getClass());
        if (tc != null && (tc1 = registry.lookup(Document.class, via)) != null) {
            Object is = tc.convertTo(via, exchange, value);
            Document document = (Document)tc1.convertTo(Document.class, exchange, is);
            return CxfPayloadConverter.documentToCxfPayload(document, exchange);
        }
        return null;
    }
}

