/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.reifier.language.SingleInputTypedExpressionReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.NamespaceAware;

public class XPathExpressionReifier
extends SingleInputTypedExpressionReifier<XPathExpression> {
    public XPathExpressionReifier(CamelContext camelContext, ExpressionDefinition definition) {
        super(camelContext, (ExpressionDefinition)((XPathExpression)definition));
    }

    @Override
    protected void configurePredicate(Predicate predicate) {
        this.configureNamespaceAware(predicate);
    }

    @Override
    protected void configureExpression(Expression expression) {
        this.configureNamespaceAware(expression);
    }

    protected void configureNamespaceAware(Object builder) {
        if (((XPathExpression)this.definition).getNamespaces() != null && builder instanceof NamespaceAware) {
            NamespaceAware namespaceAware = (NamespaceAware)builder;
            namespaceAware.setNamespaces(((XPathExpression)this.definition).getNamespaces());
        }
    }

    @Override
    protected Object[] createProperties() {
        Object[] properties = new Object[]{this.asResultType(), this.parseString(((XPathExpression)this.definition).getSource()), ((XPathExpression)this.definition).getDocumentType(), this.asQName(this.parseString(((XPathExpression)this.definition).getResultQName())), this.parseBoolean(((XPathExpression)this.definition).getSaxon()), ((XPathExpression)this.definition).getXPathFactory(), this.parseString(((XPathExpression)this.definition).getObjectModel()), this.parseBoolean(((XPathExpression)this.definition).getThreadSafety()), this.parseBoolean(((XPathExpression)this.definition).getPreCompile()), this.parseBoolean(((XPathExpression)this.definition).getLogNamespaces()), ((XPathExpression)this.definition).getNamespaces()};
        return properties;
    }

    private Object asQName(String resultTypeName) {
        if (resultTypeName == null) {
            return null;
        }
        if ("NUMBER".equalsIgnoreCase(resultTypeName)) {
            return XPathConstants.NUMBER;
        }
        if ("STRING".equalsIgnoreCase(resultTypeName)) {
            return XPathConstants.STRING;
        }
        if ("BOOLEAN".equalsIgnoreCase(resultTypeName)) {
            return XPathConstants.BOOLEAN;
        }
        if ("NODESET".equalsIgnoreCase(resultTypeName)) {
            return XPathConstants.NODESET;
        }
        if ("NODE".equalsIgnoreCase(resultTypeName)) {
            return XPathConstants.NODE;
        }
        return null;
    }

    @Override
    protected void configureLanguage(Language language) {
        if (((XPathExpression)this.definition).getDocumentType() == null && ((XPathExpression)this.definition).getDocumentTypeName() != null) {
            try {
                Class clazz = this.camelContext.getClassResolver().resolveMandatoryClass(((XPathExpression)this.definition).getDocumentTypeName());
                ((XPathExpression)this.definition).setDocumentType(clazz);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        if (((XPathExpression)this.definition).getXPathFactory() == null && ((XPathExpression)this.definition).getFactoryRef() != null) {
            ((XPathExpression)this.definition).setXPathFactory(this.mandatoryLookup(((XPathExpression)this.definition).getFactoryRef(), XPathFactory.class));
        }
    }
}

