/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.apache.camel.component.cxf.spring.AbstractCxfBeanDefinitionParser;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CxfEndpointBeanDefinitionParser
extends AbstractCxfBeanDefinitionParser {
    protected Class<?> getBeanClass(Element arg0) {
        return CxfSpringEndpoint.class;
    }

    private boolean isSpringPlaceHolder(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}") || value.startsWith("{{") && value.endsWith("}}");
    }

    protected boolean parseAttributes(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean addedBus = super.parseAttributes(element, ctx, bean);
        String bus = element.getAttribute("bus");
        if (!addedBus && !StringUtils.isEmpty((String)bus)) {
            bean.addPropertyReference("bus", bus.startsWith("#") ? bus.substring(1) : bus);
            addedBus = true;
        }
        return addedBus;
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("endpointName".equals(name) || "serviceName".equals(name)) {
            if (this.isSpringPlaceHolder(val)) {
                this.mapToProperty(bean, name, val);
            } else {
                QName q = this.parseQName(e, val);
                bean.addPropertyValue(name + "AsQName", (Object)q);
            }
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name)) {
            Map map = CastUtils.cast((Map)ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition()));
            Map<String, Object> props = this.getPropertyMap(bean, false);
            if (props != null) {
                map.putAll(props);
            }
            bean.addPropertyValue("properties", (Object)map);
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }
}

