/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CxfHeaderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CxfHeaderHelper.class);
    private static final Map<String, String> CAMEL_TO_CXF_HEADERS = new HashMap<String, String>();
    private static final Map<String, String> CXF_TO_CAMEL_HEADERS = new HashMap<String, String>();

    private CxfHeaderHelper() {
    }

    private static void defineMapping(String camelHeader, String cxfHeader) {
        CAMEL_TO_CXF_HEADERS.put(camelHeader, cxfHeader);
        CXF_TO_CAMEL_HEADERS.put(cxfHeader, camelHeader);
    }

    public static void propagateCamelHeadersToCxfHeaders(HeaderFilterStrategy strategy, Map<String, Object> camelHeaders, Map<String, List<String>> requestHeaders, Exchange camelExchange) throws Exception {
        if (strategy == null) {
            return;
        }
        camelHeaders.entrySet().forEach(entry -> {
            if (strategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), camelExchange) && CAMEL_TO_CXF_HEADERS.get(entry.getKey()) == null) {
                LOG.trace("Drop Camel header: {}={}", entry.getKey(), entry.getValue());
                return;
            }
            if ("CamelHttpMethod".equalsIgnoreCase((String)entry.getKey()) || "CamelHttpPath".equalsIgnoreCase((String)entry.getKey())) {
                return;
            }
            if (entry.getValue() == null) {
                LOG.trace("Drop Camel header: {}={}", entry.getKey(), entry.getValue());
                return;
            }
            String cxfHeaderName = CAMEL_TO_CXF_HEADERS.getOrDefault(entry.getKey(), (String)entry.getKey());
            LOG.trace("Propagate Camel header: {}={} as {}", new Object[]{entry.getKey(), entry.getValue(), cxfHeaderName});
            requestHeaders.put(cxfHeaderName, Arrays.asList(entry.getValue().toString()));
        });
    }

    public static void propagateCamelToCxf(HeaderFilterStrategy strategy, Map<String, Object> camelHeaders, org.apache.cxf.message.Message cxfMessage, Exchange exchange) {
        cxfMessage.putIfAbsent((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, new TreeMap(String.CASE_INSENSITIVE_ORDER));
        Map cxfHeaders = CastUtils.cast((Map)((Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        if (strategy == null) {
            return;
        }
        camelHeaders.entrySet().forEach(entry -> {
            if (strategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) {
                LOG.trace("Drop external header: {}={}", entry.getKey(), entry.getValue());
                return;
            }
            if (entry.getValue() == null) {
                LOG.trace("Drop Camel header: {}={}", entry.getKey(), entry.getValue());
                return;
            }
            String cxfHeaderName = CAMEL_TO_CXF_HEADERS.getOrDefault(entry.getKey(), (String)entry.getKey());
            LOG.trace("Propagate Camel header: {}={} as {}", new Object[]{entry.getKey(), entry.getValue(), cxfHeaderName});
            if ("Content-Type".equals(entry.getKey())) {
                cxfMessage.put((Object)cxfHeaderName, entry.getValue());
            }
            if ("CamelHttpResponseCode".equals(entry.getKey()) || "RequestContext".equals(entry.getKey()) || "ResponseContext".equals(entry.getKey())) {
                cxfMessage.put((Object)cxfHeaderName, entry.getValue());
            } else {
                Object values = entry.getValue();
                if (values instanceof List) {
                    cxfHeaders.put(cxfHeaderName, CastUtils.cast((List)((List)values), String.class));
                } else {
                    ArrayList<String> listValue = new ArrayList<String>();
                    listValue.add(entry.getValue().toString());
                    cxfHeaders.put(cxfHeaderName, listValue);
                }
            }
        });
    }

    public static void propagateCxfHeadersToCamelHeaders(HeaderFilterStrategy strategy, Map<String, List<Object>> responseHeaders, Map<String, Object> camelHeaders, Exchange camelExchange) throws Exception {
        if (strategy == null) {
            return;
        }
        responseHeaders.entrySet().forEach(entry -> {
            if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), camelExchange)) {
                LOG.trace("Drop external header: {}={}", entry.getKey(), entry.getValue());
                return;
            }
            String camelHeaderName = CXF_TO_CAMEL_HEADERS.getOrDefault(entry.getKey(), (String)entry.getKey());
            LOG.trace("Populate external header: {}={} as {}", new Object[]{entry.getKey(), entry.getValue(), camelHeaderName});
            camelHeaders.put(camelHeaderName, ((List)entry.getValue()).get(0));
        });
    }

    public static void propagateCxfToCamel(HeaderFilterStrategy strategy, org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        if (strategy == null) {
            return;
        }
        CxfHeaderHelper.copyProtocolHeadersFromCxfToCamel(strategy, exchange, cxfMessage, camelMessage);
        CxfHeaderHelper.copyHttpHeadersFromCxfToCamel(strategy, cxfMessage, camelMessage, exchange);
        CxfHeaderHelper.copyCxfHeaderToCamel(strategy, exchange, cxfMessage, camelMessage, "RequestContext");
        CxfHeaderHelper.copyCxfHeaderToCamel(strategy, exchange, cxfMessage, camelMessage, "ResponseContext");
    }

    private static void copyProtocolHeadersFromCxfToCamel(HeaderFilterStrategy strategy, Exchange exchange, org.apache.cxf.message.Message cxfMessage, Message camelMessage) {
        Map cxfHeaders = CastUtils.cast((Map)((Map)cxfMessage.getOrDefault((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, Collections.emptyMap())));
        cxfHeaders.entrySet().forEach(cxfHeader -> {
            String camelHeaderName = CXF_TO_CAMEL_HEADERS.getOrDefault(cxfHeader.getKey(), (String)cxfHeader.getKey());
            Object value = CxfHeaderHelper.convertCxfProtocolHeaderValues((List)cxfHeader.getValue(), exchange);
            CxfHeaderHelper.copyCxfHeaderToCamel(strategy, exchange, cxfMessage, camelMessage, (String)cxfHeader.getKey(), camelHeaderName, value);
        });
    }

    private static Object convertCxfProtocolHeaderValues(List<String> values, Exchange exchange) {
        if (values.size() == 1) {
            return values.get(0);
        }
        if (((Boolean)exchange.getProperty("CamelCxfProtocolHeadersMerged", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return String.join((CharSequence)", ", values);
        }
        return values;
    }

    public static void copyHttpHeadersFromCxfToCamel(HeaderFilterStrategy strategy, org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        CXF_TO_CAMEL_HEADERS.entrySet().forEach(entry -> CxfHeaderHelper.copyCxfHeaderToCamel(strategy, exchange, cxfMessage, camelMessage, (String)entry.getKey(), (String)entry.getValue()));
    }

    private static void copyCxfHeaderToCamel(HeaderFilterStrategy strategy, Exchange exchange, org.apache.cxf.message.Message cxfMessage, Message camelMessage, String key) {
        CxfHeaderHelper.copyCxfHeaderToCamel(strategy, exchange, cxfMessage, camelMessage, key, key);
    }

    private static void copyCxfHeaderToCamel(HeaderFilterStrategy strategy, Exchange exchange, org.apache.cxf.message.Message cxfMessage, Message camelMessage, String cxfKey, String camelKey) {
        CxfHeaderHelper.copyCxfHeaderToCamel(strategy, exchange, cxfMessage, camelMessage, cxfKey, camelKey, cxfMessage.get((Object)cxfKey));
    }

    private static void copyCxfHeaderToCamel(HeaderFilterStrategy strategy, Exchange exchange, org.apache.cxf.message.Message cxfMessage, Message camelMessage, String cxfKey, String camelKey, Object initialValue) {
        Object value = initialValue;
        if (org.apache.cxf.message.Message.PATH_INFO.equals(cxfKey)) {
            value = CxfHeaderHelper.convertPathInfo(cxfMessage);
        } else if ("Content-Type".equals(cxfKey)) {
            value = CxfHeaderHelper.determineContentType(cxfMessage);
        }
        if (value != null && !strategy.applyFilterToExternalHeaders(cxfKey, value, exchange)) {
            camelMessage.setHeader(camelKey, value);
        }
    }

    private static String convertPathInfo(org.apache.cxf.message.Message message) {
        String pathInfo = CxfHeaderHelper.findHeaderValue(message, org.apache.cxf.message.Message.PATH_INFO);
        String basePath = CxfHeaderHelper.findHeaderValue(message, org.apache.cxf.message.Message.BASE_PATH);
        if (pathInfo != null && basePath != null && pathInfo.startsWith(basePath)) {
            return pathInfo.substring(basePath.length());
        }
        return pathInfo;
    }

    private static String determineContentType(org.apache.cxf.message.Message message) {
        String ct = CxfHeaderHelper.findHeaderValue(message, "Content-Type");
        String enc = CxfHeaderHelper.findHeaderValue(message, org.apache.cxf.message.Message.ENCODING);
        if (null != ct) {
            if (enc != null && !ct.contains("charset=") && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        message.put((Object)"Content-Type", (Object)ct);
        return ct;
    }

    private static String findHeaderValue(org.apache.cxf.message.Message message, String key) {
        String value = (String)message.get((Object)key);
        if (value != null) {
            return value;
        }
        Map protocolHeaders = CastUtils.cast((Map)((Map)message.getOrDefault((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS, Collections.emptyMap())));
        return protocolHeaders.getOrDefault(key, Collections.singletonList(null)).get(0);
    }

    static {
        CxfHeaderHelper.defineMapping("CamelHttpUri", "org.apache.cxf.request.uri");
        CxfHeaderHelper.defineMapping("CamelHttpMethod", "org.apache.cxf.request.method");
        CxfHeaderHelper.defineMapping("CamelHttpPath", org.apache.cxf.message.Message.PATH_INFO);
        CxfHeaderHelper.defineMapping("Content-Type", "Content-Type");
        CxfHeaderHelper.defineMapping("CamelHttpCharacterEncoding", org.apache.cxf.message.Message.ENCODING);
        CxfHeaderHelper.defineMapping("CamelHttpQuery", org.apache.cxf.message.Message.QUERY_STRING);
        CxfHeaderHelper.defineMapping("CamelAcceptContentType", "Accept");
        CxfHeaderHelper.defineMapping("CamelHttpResponseCode", org.apache.cxf.message.Message.RESPONSE_CODE);
    }
}

