/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DigitalSignatureEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":cryptoOperation:name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "crypto".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "cryptoOperation", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "name", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(22);
        props.add("clearHeaders");
        props.add("synchronous");
        props.add("certificate");
        props.add("certificateName");
        props.add("keystoreName");
        props.add("publicKey");
        props.add("cryptoOperation");
        props.add("publicKeyName");
        props.add("secureRandomName");
        props.add("keyStoreParameters");
        props.add("privateKey");
        props.add("lazyStartProducer");
        props.add("secureRandom");
        props.add("password");
        props.add("provider");
        props.add("privateKeyName");
        props.add("name");
        props.add("alias");
        props.add("keystore");
        props.add("signatureHeaderName");
        props.add("algorithm");
        props.add("bufferSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("privateKey");
        secretProps.add("secureRandom");
        secretProps.add("password");
        secretProps.add("privateKeyName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

