/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataConsumer;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.jackson.JacksonTokenDataWriter$WhenMappings;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataWriter;", "Lcom/worldturner/medeia/parser/JsonTokenDataConsumer;", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "(Lcom/fasterxml/jackson/core/JsonGenerator;)V", "getGenerator", "()Lcom/fasterxml/jackson/core/JsonGenerator;", "consume", "", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "medeia-validator-jackson"})
public final class JacksonTokenDataWriter
implements JsonTokenDataConsumer {
    @NotNull
    private final JsonGenerator generator;

    public void consume(@NotNull JsonTokenData token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        switch (JacksonTokenDataWriter$WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
            case 1: {
                this.generator.writeNull();
                break;
            }
            case 2: {
                this.generator.writeString(token.getText());
                break;
            }
            case 3: {
                this.generator.writeBoolean(false);
                break;
            }
            case 4: {
                this.generator.writeBoolean(true);
                break;
            }
            case 5: {
                if (token.hasLongValue()) {
                    this.generator.writeNumber(token.getLongValue());
                    break;
                }
                BigInteger bigInteger = token.getInteger();
                if (bigInteger != null) {
                    BigInteger bigInteger2;
                    BigInteger it = bigInteger2 = bigInteger;
                    boolean bl = false;
                    this.generator.writeNumber(it);
                    break;
                }
                BigDecimal bigDecimal = token.getDecimal();
                if (bigDecimal != null) {
                    BigDecimal bigDecimal2;
                    BigDecimal it = bigDecimal2 = bigDecimal;
                    boolean bl = false;
                    this.generator.writeNumber(it);
                }
                break;
            }
            case 6: {
                this.generator.writeStartObject();
                break;
            }
            case 7: {
                this.generator.writeEndObject();
                break;
            }
            case 8: {
                this.generator.writeStartArray();
                break;
            }
            case 9: {
                this.generator.writeEndArray();
                break;
            }
            case 10: {
                this.generator.writeFieldName(token.getText());
            }
        }
    }

    @NotNull
    public final JsonGenerator getGenerator() {
        return this.generator;
    }

    public JacksonTokenDataWriter(@NotNull JsonGenerator generator) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        this.generator = generator;
    }

    public void consume(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        JsonTokenDataConsumer.DefaultImpls.consume((JsonTokenDataConsumer)this, (JsonTokenData)token, (JsonTokenLocation)location);
    }
}

