/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.api.OkValidationResult;
import com.worldturner.medeia.api.ValidationResult;
import com.worldturner.medeia.parser.ArrayNode;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.parser.ObjectNode;
import com.worldturner.medeia.parser.TreeNode;
import com.worldturner.medeia.schema.validation.ArrayVerifier;
import com.worldturner.medeia.schema.validation.ConstValidatorInstance$WhenMappings;
import com.worldturner.medeia.schema.validation.ConstValidatorKt;
import com.worldturner.medeia.schema.validation.ConstVerifier;
import com.worldturner.medeia.schema.validation.ObjectVerifier;
import com.worldturner.medeia.schema.validation.SingleVerifier;
import com.worldturner.medeia.schema.validation.stream.SchemaValidatorInstance;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/worldturner/medeia/schema/validation/ConstValidatorInstance;", "Lcom/worldturner/medeia/schema/validation/stream/SchemaValidatorInstance;", "startLevel", "", "const", "Lcom/worldturner/medeia/parser/TreeNode;", "(ILcom/worldturner/medeia/parser/TreeNode;)V", "getConst", "()Lcom/worldturner/medeia/parser/TreeNode;", "constStack", "Ljava/util/Deque;", "currentConst", "currentProperty", "", "getStartLevel", "()I", "verificationStack", "Lcom/worldturner/medeia/schema/validation/ConstVerifier;", "validate", "Lcom/worldturner/medeia/api/ValidationResult;", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "medeia-validator-core"})
public final class ConstValidatorInstance
implements SchemaValidatorInstance {
    private final Deque<ConstVerifier> verificationStack;
    private final Deque<TreeNode> constStack;
    private String currentProperty;
    private TreeNode currentConst;
    private final int startLevel;
    @NotNull
    private final TreeNode const;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ValidationResult validate(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        ValidationResult result;
        ConstVerifier top;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (token.getType() == JsonTokenType.FIELD_NAME) {
            String string = token.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.currentProperty = string;
            return null;
        }
        TreeNode currentConst = this.currentConst;
        if (token.getType().getFirstToken()) {
            ConstVerifier constVerifier;
            top = this.verificationStack.isEmpty() ? null : this.verificationStack.peek();
            ConstVerifier constVerifier2 = top;
            if (constVerifier2 instanceof ObjectVerifier) {
                Set<String> set = ((ObjectVerifier)top).getPropertyNames();
                String string = this.currentProperty;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                set.add(string);
                if (!(currentConst instanceof ObjectNode)) return ConstValidatorKt.access$fail(location, "Const validation failed at level " + this.verificationStack.size() + ", " + "const value is not an object at this point");
                this.constStack.push(currentConst);
                Map<String, TreeNode> map = ((ObjectNode)currentConst).getNodes();
                String string2 = this.currentProperty;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                TreeNode treeNode = map.get(string2);
                if (treeNode == null) {
                    return ConstValidatorKt.access$fail(location, "Const validation failed at level " + this.verificationStack.size() + ", " + "property " + this.currentProperty + " doesn't exist in const value");
                }
                this.currentConst = treeNode;
            } else if (constVerifier2 instanceof ArrayVerifier) {
                if (!(currentConst instanceof ArrayNode)) return ConstValidatorKt.access$fail(location, "Const validation failed at level " + this.verificationStack.size() + ", " + "const value is not an array at this point");
                if (((ArrayNode)currentConst).getNodes().size() <= ((ArrayVerifier)top).getItemCount()) {
                    return ConstValidatorKt.access$fail(location, "Const validation failed at level " + this.verificationStack.size() + ", " + "index " + ((ArrayVerifier)top).getItemCount() + " doesn't exist in array in const value");
                }
                this.constStack.push(currentConst);
                this.currentConst = ((ArrayNode)currentConst).getNodes().get(((ArrayVerifier)top).getItemCount());
                ArrayVerifier arrayVerifier = (ArrayVerifier)top;
                int n = arrayVerifier.getItemCount();
                arrayVerifier.setItemCount(n + 1);
            }
            switch (ConstValidatorInstance$WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
                case 1: {
                    constVerifier = new ObjectVerifier();
                    break;
                }
                case 2: {
                    constVerifier = new ArrayVerifier();
                    break;
                }
                default: {
                    constVerifier = new SingleVerifier(token);
                }
            }
            ConstVerifier verifier = constVerifier;
            this.verificationStack.push(verifier);
        }
        if (!token.getType().getLastToken()) return null;
        ConstVerifier constVerifier = this.verificationStack.pop();
        if (constVerifier == null) {
            Intrinsics.throwNpe();
        }
        top = constVerifier;
        TreeNode treeNode = this.currentConst;
        if (treeNode == null) {
            Intrinsics.throwNpe();
        }
        if (!(result = top.verify(treeNode, location)).getValid()) {
            return result;
        }
        TreeNode treeNode2 = this.currentConst = this.constStack.isEmpty() ? null : this.constStack.pop();
        if (location.getLevel() != this.startLevel) return null;
        return OkValidationResult.INSTANCE;
    }

    public final int getStartLevel() {
        return this.startLevel;
    }

    @NotNull
    public final TreeNode getConst() {
        return this.const;
    }

    public ConstValidatorInstance(int startLevel, @NotNull TreeNode treeNode) {
        Intrinsics.checkParameterIsNotNull((Object)treeNode, (String)"const");
        this.startLevel = startLevel;
        this.const = treeNode;
        this.verificationStack = new ArrayDeque();
        this.constStack = new ArrayDeque();
        this.currentConst = this.const;
    }
}

