/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.crypto.DigitalSignatureComponent;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class DigitalSignatureComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private DigitalSignatureConfiguration getOrCreateConfiguration(DigitalSignatureComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DigitalSignatureConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DigitalSignatureComponent target = (DigitalSignatureComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                this.getOrCreateConfiguration(target).setAlgorithm((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "alias": {
                this.getOrCreateConfiguration(target).setAlias((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                this.getOrCreateConfiguration(target).setBufferSize((Integer)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "certificate": {
                this.getOrCreateConfiguration(target).setCertificate((Certificate)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, Certificate.class, (Object)value));
                return true;
            }
            case "certificatename": 
            case "certificateName": {
                this.getOrCreateConfiguration(target).setCertificateName((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clearheaders": 
            case "clearHeaders": {
                this.getOrCreateConfiguration(target).setClearHeaders((Boolean)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((DigitalSignatureConfiguration)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, DigitalSignatureConfiguration.class, (Object)value));
                return true;
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                this.getOrCreateConfiguration(target).setKeyStoreParameters((KeyStoreParameters)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, KeyStoreParameters.class, (Object)value));
                return true;
            }
            case "keystore": {
                this.getOrCreateConfiguration(target).setKeystore((KeyStore)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, KeyStore.class, (Object)value));
                return true;
            }
            case "keystorename": 
            case "keystoreName": {
                this.getOrCreateConfiguration(target).setKeystoreName((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "privatekey": 
            case "privateKey": {
                this.getOrCreateConfiguration(target).setPrivateKey((PrivateKey)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "privatekeyname": 
            case "privateKeyName": {
                this.getOrCreateConfiguration(target).setPrivateKeyName((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "provider": {
                this.getOrCreateConfiguration(target).setProvider((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "publickey": 
            case "publicKey": {
                this.getOrCreateConfiguration(target).setPublicKey((PublicKey)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, PublicKey.class, (Object)value));
                return true;
            }
            case "publickeyname": 
            case "publicKeyName": {
                this.getOrCreateConfiguration(target).setPublicKeyName((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securerandom": 
            case "secureRandom": {
                this.getOrCreateConfiguration(target).setSecureRandom((SecureRandom)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, SecureRandom.class, (Object)value));
                return true;
            }
            case "securerandomname": 
            case "secureRandomName": {
                this.getOrCreateConfiguration(target).setSecureRandomName((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                this.getOrCreateConfiguration(target).setSignatureHeaderName((String)DigitalSignatureComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("algorithm", String.class);
        answer.put("alias", String.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bufferSize", Integer.class);
        answer.put("certificate", Certificate.class);
        answer.put("certificateName", String.class);
        answer.put("clearHeaders", Boolean.TYPE);
        answer.put("configuration", DigitalSignatureConfiguration.class);
        answer.put("keyStoreParameters", KeyStoreParameters.class);
        answer.put("keystore", KeyStore.class);
        answer.put("keystoreName", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("password", String.class);
        answer.put("privateKey", PrivateKey.class);
        answer.put("privateKeyName", String.class);
        answer.put("provider", String.class);
        answer.put("publicKey", PublicKey.class);
        answer.put("publicKeyName", String.class);
        answer.put("secureRandom", SecureRandom.class);
        answer.put("secureRandomName", String.class);
        answer.put("signatureHeaderName", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DigitalSignatureComponent target = (DigitalSignatureComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return this.getOrCreateConfiguration(target).getAlgorithm();
            }
            case "alias": {
                return this.getOrCreateConfiguration(target).getAlias();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "buffersize": 
            case "bufferSize": {
                return this.getOrCreateConfiguration(target).getBufferSize();
            }
            case "certificate": {
                return this.getOrCreateConfiguration(target).getCertificate();
            }
            case "certificatename": 
            case "certificateName": {
                return this.getOrCreateConfiguration(target).getCertificateName();
            }
            case "clearheaders": 
            case "clearHeaders": {
                return this.getOrCreateConfiguration(target).isClearHeaders();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                return this.getOrCreateConfiguration(target).getKeyStoreParameters();
            }
            case "keystore": {
                return this.getOrCreateConfiguration(target).getKeystore();
            }
            case "keystorename": 
            case "keystoreName": {
                return this.getOrCreateConfiguration(target).getKeystoreName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "privatekey": 
            case "privateKey": {
                return this.getOrCreateConfiguration(target).getPrivateKey();
            }
            case "privatekeyname": 
            case "privateKeyName": {
                return this.getOrCreateConfiguration(target).getPrivateKeyName();
            }
            case "provider": {
                return this.getOrCreateConfiguration(target).getProvider();
            }
            case "publickey": 
            case "publicKey": {
                return this.getOrCreateConfiguration(target).getPublicKey();
            }
            case "publickeyname": 
            case "publicKeyName": {
                return this.getOrCreateConfiguration(target).getPublicKeyName();
            }
            case "securerandom": 
            case "secureRandom": {
                return this.getOrCreateConfiguration(target).getSecureRandom();
            }
            case "securerandomname": 
            case "secureRandomName": {
                return this.getOrCreateConfiguration(target).getSecureRandomName();
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                return this.getOrCreateConfiguration(target).getSignatureHeaderName();
            }
        }
        return null;
    }
}

