/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.main.MainShutdownStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMainShutdownStrategy
implements MainShutdownStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(SimpleMainShutdownStrategy.class);
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public boolean isRunAllowed() {
        return !this.completed.get();
    }

    @Override
    public boolean shutdown() {
        if (this.completed.compareAndSet(false, true)) {
            this.latch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public void await() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        this.latch.await(timeout, unit);
    }
}

