/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.TransactedPolicy;

@Metadata(label="configuration")
@XmlRootElement(name="policy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PolicyDefinition
extends OutputDefinition<PolicyDefinition> {
    @XmlTransient
    protected Class<? extends Policy> type;
    @XmlAttribute(required=true)
    protected String ref;
    @XmlTransient
    private Policy policy;

    public PolicyDefinition() {
    }

    public PolicyDefinition(Policy policy) {
        this.policy = policy;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public String toString() {
        return "Policy[" + this.description() + "]";
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Class<? extends Policy> getType() {
        return this.type;
    }

    protected String description() {
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "ref:" + this.ref;
    }

    @Override
    public String getShortName() {
        boolean transacted = this.type != null && this.type.isAssignableFrom(TransactedPolicy.class);
        return transacted ? "transacted" : "policy";
    }

    @Override
    public String getLabel() {
        return this.getShortName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isTopLevelOnly() {
        return false;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setType(Class<? extends Policy> type) {
        this.type = type;
    }

    public PolicyDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }
}

