/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.FaultToleranceConfigurationProperties;
import org.apache.camel.main.HystrixConfigurationProperties;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.spi.Configurer;

@Configurer
public class MainConfigurationProperties
extends DefaultConfigurationProperties<MainConfigurationProperties> {
    private boolean autoConfigurationEnabled = true;
    private boolean autoConfigurationEnvironmentVariablesEnabled = true;
    private boolean autoConfigurationFailFast = true;
    private boolean autoConfigurationLogSummary = true;
    private boolean autowireComponentProperties = true;
    private boolean autowireComponentPropertiesDeep;
    private boolean autowireComponentPropertiesNonNullOnly;
    private boolean autowireComponentPropertiesAllowPrivateSetter = true;
    private int durationHitExitCode;
    private boolean hangupInterceptorEnabled = true;
    private String packageScanRouteBuilders;
    private String routesBuilderClasses;
    private String configurationClasses;
    private List<RoutesBuilder> routesBuilders = new ArrayList<RoutesBuilder>();
    private List<Object> configurations = new ArrayList<Object>();
    private final HystrixConfigurationProperties hystrixConfigurationProperties = new HystrixConfigurationProperties(this);
    private final Resilience4jConfigurationProperties resilience4jConfigurationProperties = new Resilience4jConfigurationProperties(this);
    private final FaultToleranceConfigurationProperties faultToleranceConfigurationProperties = new FaultToleranceConfigurationProperties(this);
    private final RestConfigurationProperties restConfigurationProperties = new RestConfigurationProperties(this);

    public HystrixConfigurationProperties hystrix() {
        return this.hystrixConfigurationProperties;
    }

    public Resilience4jConfigurationProperties resilience4j() {
        return this.resilience4jConfigurationProperties;
    }

    public FaultToleranceConfigurationProperties faultTolerance() {
        return this.faultToleranceConfigurationProperties;
    }

    public RestConfigurationProperties rest() {
        return this.restConfigurationProperties;
    }

    public boolean isAutoConfigurationEnabled() {
        return this.autoConfigurationEnabled;
    }

    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
    }

    public boolean isAutoConfigurationEnvironmentVariablesEnabled() {
        return this.autoConfigurationEnvironmentVariablesEnabled;
    }

    public void setAutoConfigurationEnvironmentVariablesEnabled(boolean autoConfigurationEnvironmentVariablesEnabled) {
        this.autoConfigurationEnvironmentVariablesEnabled = autoConfigurationEnvironmentVariablesEnabled;
    }

    public boolean isAutoConfigurationFailFast() {
        return this.autoConfigurationFailFast;
    }

    public void setAutoConfigurationFailFast(boolean autoConfigurationFailFast) {
        this.autoConfigurationFailFast = autoConfigurationFailFast;
    }

    public boolean isAutoConfigurationLogSummary() {
        return this.autoConfigurationLogSummary;
    }

    public void setAutoConfigurationLogSummary(boolean autoConfigurationLogSummary) {
        this.autoConfigurationLogSummary = autoConfigurationLogSummary;
    }

    public boolean isAutowireComponentProperties() {
        return this.autowireComponentProperties;
    }

    public void setAutowireComponentProperties(boolean autowireComponentProperties) {
        this.autowireComponentProperties = autowireComponentProperties;
    }

    public boolean isAutowireComponentPropertiesDeep() {
        return this.autowireComponentPropertiesDeep;
    }

    public void setAutowireComponentPropertiesDeep(boolean autowireComponentPropertiesDeep) {
        this.autowireComponentPropertiesDeep = autowireComponentPropertiesDeep;
    }

    public boolean isAutowireComponentPropertiesNonNullOnly() {
        return this.autowireComponentPropertiesNonNullOnly;
    }

    public void setAutowireComponentPropertiesNonNullOnly(boolean autowireComponentPropertiesNonNullOnly) {
        this.autowireComponentPropertiesNonNullOnly = autowireComponentPropertiesNonNullOnly;
    }

    public boolean isAutowireComponentPropertiesAllowPrivateSetter() {
        return this.autowireComponentPropertiesAllowPrivateSetter;
    }

    public void setAutowireComponentPropertiesAllowPrivateSetter(boolean autowireComponentPropertiesAllowPrivateSetter) {
        this.autowireComponentPropertiesAllowPrivateSetter = autowireComponentPropertiesAllowPrivateSetter;
    }

    public boolean isHangupInterceptorEnabled() {
        return this.hangupInterceptorEnabled;
    }

    public void setHangupInterceptorEnabled(boolean hangupInterceptorEnabled) {
        this.hangupInterceptorEnabled = hangupInterceptorEnabled;
    }

    public String getPackageScanRouteBuilders() {
        return this.packageScanRouteBuilders;
    }

    public void setPackageScanRouteBuilders(String packageScanRouteBuilders) {
        this.packageScanRouteBuilders = packageScanRouteBuilders;
    }

    public int getDurationHitExitCode() {
        return this.durationHitExitCode;
    }

    public void setDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    public void addConfigurationClass(Class<?> ... configuration) {
        String existing = this.configurationClasses;
        if (existing == null) {
            existing = "";
        }
        if (configuration != null) {
            for (Class<?> clazz : configuration) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setConfigurationClasses(existing);
    }

    public void addConfiguration(Object configuration) {
        this.configurations.add(configuration);
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Object> configurations) {
        this.configurations = configurations;
    }

    public String getRoutesBuilderClasses() {
        return this.routesBuilderClasses;
    }

    public void setRoutesBuilderClasses(String builders) {
        this.routesBuilderClasses = builders;
    }

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routesBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routesBuilders = routesBuilders;
    }

    public void addRoutesBuilder(RoutesBuilder routeBuilder) {
        this.routesBuilders.add(routeBuilder);
    }

    public void addRoutesBuilder(Class<?> ... routeBuilder) {
        String existing = this.routesBuilderClasses;
        if (existing == null) {
            existing = "";
        }
        if (routeBuilder != null) {
            for (Class<?> clazz : routeBuilder) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setRoutesBuilderClasses(existing);
    }

    public MainConfigurationProperties withAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationEnvironmentVariablesEnabled(boolean autoConfigurationEnvironmentVariablesEnabled) {
        this.autoConfigurationEnvironmentVariablesEnabled = autoConfigurationEnvironmentVariablesEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationFailFast(boolean autoConfigurationFailFast) {
        this.autoConfigurationFailFast = autoConfigurationFailFast;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationLogSummary(boolean autoConfigurationLogSummary) {
        this.autoConfigurationLogSummary = autoConfigurationLogSummary;
        return this;
    }

    public MainConfigurationProperties withAutowireComponentProperties(boolean autowireComponentProperties) {
        this.autowireComponentProperties = autowireComponentProperties;
        return this;
    }

    public MainConfigurationProperties withAutowireComponentPropertiesDeep(boolean autowireComponentPropertiesDeep) {
        this.autowireComponentPropertiesDeep = autowireComponentPropertiesDeep;
        return this;
    }

    public MainConfigurationProperties withAutowireComponentPropertiesNonNullOnly(boolean autowireComponentPropertiesNonNullOnly) {
        this.autowireComponentPropertiesNonNullOnly = autowireComponentPropertiesNonNullOnly;
        return this;
    }

    public MainConfigurationProperties withAutowireComponentPropertiesAllowPrivateSetter(boolean autowireComponentPropertiesAllowPrivateSetter) {
        this.autowireComponentPropertiesAllowPrivateSetter = autowireComponentPropertiesAllowPrivateSetter;
        return this;
    }

    public MainConfigurationProperties withHangupInterceptorEnabled(boolean hangupInterceptorEnabled) {
        this.hangupInterceptorEnabled = hangupInterceptorEnabled;
        return this;
    }

    public MainConfigurationProperties withDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
        return this;
    }

    public MainConfigurationProperties withPackageScanRouteBuilders(String packageScanRouteBuilders) {
        this.packageScanRouteBuilders = packageScanRouteBuilders;
        return this;
    }

    public MainConfigurationProperties withConfigurationClasses(String configurations) {
        this.setConfigurationClasses(configurations);
        return this;
    }

    public MainConfigurationProperties withAdditionalConfigurationClasses(Class ... configuration) {
        this.addConfigurationClass(configuration);
        return this;
    }

    public MainConfigurationProperties withAdditionalConfiguration(Object configuration) {
        this.addConfiguration(configuration);
        return this;
    }

    public MainConfigurationProperties withConfigurations(List<Object> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public MainConfigurationProperties withRoutesBuilderClasses(String builders) {
        this.setRoutesBuilderClasses(builders);
        return this;
    }

    public MainConfigurationProperties withRoutesBuilders(List<RoutesBuilder> builders) {
        this.setRoutesBuilders(builders);
        return this;
    }

    public MainConfigurationProperties withAdditionalRoutesBuilder(RoutesBuilder builder) {
        this.addRoutesBuilder(builder);
        return this;
    }

    public MainConfigurationProperties withAdditionalRoutesBuilder(Class ... builders) {
        this.addRoutesBuilder(builders);
        return this;
    }
}

