/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client.request;

import io.apicurio.registry.utils.ConcurrentUtil;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class RequestHandler {
    public <T> T execute(Call<T> call) {
        ResultCallback resultCallback = new ResultCallback();
        call.enqueue(resultCallback);
        return resultCallback.getResult();
    }

    private static class ResultCallback<T>
    implements Callback<T> {
        private static final Logger logger = Logger.getLogger(ResultCallback.class.getName());
        private final CompletableFuture<T> result = new CompletableFuture();

        public void onResponse(Call<T> call, Response<T> response) {
            if (response.isSuccessful()) {
                this.result.complete(response.body());
            } else {
                this.result.completeExceptionally((Throwable)new WebApplicationException(response.message(), response.code()));
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            this.result.completeExceptionally(t);
        }

        public T getResult() {
            try {
                return (T)ConcurrentUtil.get(this.result);
            }
            catch (RuntimeException e) {
                this.handleError(e);
                return null;
            }
        }

        private void handleError(Throwable e) {
            if (e instanceof WebApplicationException) {
                throw (WebApplicationException)e;
            }
            logger.log(Level.SEVERE, "Error getting call result", e);
        }
    }
}

