/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.common;

import java.io.Closeable;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.crypto.cms.common.CryptoCmsUnMarshallerConfiguration;
import org.apache.camel.util.IOHelper;
import org.apache.commons.codec.binary.Base64InputStream;
import org.bouncycastle.cert.X509CertificateHolder;

public abstract class CryptoCmsUnmarshaller
implements Processor {
    private final CryptoCmsUnMarshallerConfiguration config;

    public CryptoCmsUnmarshaller(CryptoCmsUnMarshallerConfiguration config) {
        this.config = config;
    }

    public CryptoCmsUnMarshallerConfiguration getConfiguration() {
        return this.config;
    }

    public void process(Exchange exchange) throws Exception {
        InputStream stream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        try {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            if (this.config.isFromBase64()) {
                stream = new Base64InputStream(stream);
            }
            Object result = this.unmarshalInternal(stream, exchange);
            out.setBody(result);
        }
        catch (Throwable e) {
            exchange.setOut(null);
            throw e;
        }
        finally {
            IOHelper.close((Closeable)stream, (String)"input stream");
        }
    }

    protected abstract Object unmarshalInternal(InputStream var1, Exchange var2) throws Exception;

    protected String certsToString(Collection<X509Certificate> certs) {
        if (certs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int size = certs.size();
        int counter = 0;
        for (X509Certificate cert : certs) {
            ++counter;
            sb.append('[');
            this.certToString(sb, cert);
            sb.append("]");
            if (counter >= size) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    protected String issuerSerialNumberSubject(X509CertificateHolder cert) {
        StringBuilder sb = new StringBuilder();
        sb.append("Issuer=(");
        sb.append(cert.getIssuer());
        sb.append("), SerialNumber=");
        sb.append(cert.getSerialNumber());
        sb.append(", Subject=(");
        sb.append(cert.getSubject());
        sb.append(')');
        return sb.toString();
    }

    protected void certToString(StringBuilder sb, X509Certificate cert) {
        sb.append("Issuer=(");
        sb.append(cert.getIssuerX500Principal().getName());
        sb.append("), SerialNumber=");
        sb.append(cert.getSerialNumber());
        sb.append(", Subject=(");
        sb.append(cert.getSubjectX500Principal().getName());
        sb.append(')');
    }
}

