/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public interface TraversalParent
extends AutoCloseable {
    default public <S, E> List<Traversal.Admin<S, E>> getGlobalChildren() {
        return Collections.emptyList();
    }

    default public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return Collections.emptyList();
    }

    default public void addLocalChild(Traversal.Admin<?, ?> localChildTraversal) {
        throw new IllegalStateException("This traversal parent does not support the addition of local traversals: " + this.getClass().getCanonicalName());
    }

    default public void addGlobalChild(Traversal.Admin<?, ?> globalChildTraversal) {
        throw new IllegalStateException("This traversal parent does not support the addition of global traversals: " + this.getClass().getCanonicalName());
    }

    default public void removeLocalChild(Traversal.Admin<?, ?> localChildTraversal) {
        throw new IllegalStateException("This traversal parent does not support the removal of local traversals: " + this.getClass().getCanonicalName());
    }

    default public void removeGlobalChild(Traversal.Admin<?, ?> globalChildTraversal) {
        throw new IllegalStateException("This traversal parent does not support the removal of global traversals: " + this.getClass().getCanonicalName());
    }

    default public Set<TraverserRequirement> getSelfAndChildRequirements(TraverserRequirement ... selfRequirements) {
        EnumSet<TraverserRequirement> requirements = EnumSet.noneOf(TraverserRequirement.class);
        Collections.addAll(requirements, selfRequirements);
        for (Traversal.Admin local : this.getLocalChildren()) {
            requirements.addAll(local.getTraverserRequirements());
        }
        for (Traversal.Admin global : this.getGlobalChildren()) {
            requirements.addAll(global.getTraverserRequirements());
        }
        return requirements;
    }

    default public Step<?, ?> asStep() {
        return (Step)((Object)this);
    }

    default public <S, E> Traversal.Admin<S, E> integrateChild(Traversal.Admin<?, ?> childTraversal) {
        if (null == childTraversal) {
            return null;
        }
        childTraversal.setParent(this);
        childTraversal.getSideEffects().mergeInto(this.asStep().getTraversal().getSideEffects());
        childTraversal.setSideEffects(this.asStep().getTraversal().getSideEffects());
        return childTraversal;
    }

    @Override
    default public void close() throws Exception {
        for (Traversal.Admin traversal : this.getLocalChildren()) {
            traversal.close();
        }
        for (Traversal.Admin traversal : this.getGlobalChildren()) {
            traversal.close();
        }
    }
}

