/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class PrimitiveType
implements DataType,
Serializable {
    private final int protocolCode;

    public PrimitiveType(int protocolCode) {
        this.protocolCode = protocolCode;
    }

    @Override
    public int getProtocolCode() {
        return this.protocolCode;
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PrimitiveType) {
            PrimitiveType that = (PrimitiveType)other;
            return this.protocolCode == that.protocolCode;
        }
        return false;
    }

    public int hashCode() {
        return this.protocolCode;
    }

    @Override
    @NonNull
    public String asCql(boolean includeFrozen, boolean pretty) {
        return PrimitiveType.codeName(this.protocolCode).toLowerCase();
    }

    public String toString() {
        return PrimitiveType.codeName(this.protocolCode);
    }

    private static String codeName(int protocolCode) {
        switch (protocolCode) {
            case 1: {
                return "ASCII";
            }
            case 2: {
                return "BIGINT";
            }
            case 3: {
                return "BLOB";
            }
            case 4: {
                return "BOOLEAN";
            }
            case 5: {
                return "COUNTER";
            }
            case 6: {
                return "DECIMAL";
            }
            case 7: {
                return "DOUBLE";
            }
            case 8: {
                return "FLOAT";
            }
            case 9: {
                return "INT";
            }
            case 11: {
                return "TIMESTAMP";
            }
            case 12: {
                return "UUID";
            }
            case 14: {
                return "VARINT";
            }
            case 15: {
                return "TIMEUUID";
            }
            case 16: {
                return "INET";
            }
            case 17: {
                return "DATE";
            }
            case 13: {
                return "TEXT";
            }
            case 18: {
                return "TIME";
            }
            case 19: {
                return "SMALLINT";
            }
            case 20: {
                return "TINYINT";
            }
            case 21: {
                return "DURATION";
            }
        }
        return "0x" + Integer.toHexString(protocolCode);
    }
}

