/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.utils.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.SelectFrom;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;

public final class CassandraUtils {
    private CassandraUtils() {
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Object[] concat(Object[] array1, Object[] array2) {
        if (CassandraUtils.isEmpty(array1)) {
            return array2;
        }
        if (CassandraUtils.isEmpty(array2)) {
            return array1;
        }
        Object[] array = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    private static int size(String[] array) {
        return array == null ? 0 : array.length;
    }

    private static boolean isEmpty(String[] array) {
        return CassandraUtils.size(array) == 0;
    }

    public static String[] concat(String[] array1, String[] array2) {
        if (CassandraUtils.isEmpty(array1)) {
            return array2;
        }
        if (CassandraUtils.isEmpty(array2)) {
            return array1;
        }
        String[] array = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    public static Object[] append(Object[] array1, Object ... array2) {
        return CassandraUtils.concat(array1, array2);
    }

    public static String[] append(String[] array1, String ... array2) {
        return CassandraUtils.concat(array1, array2);
    }

    public static Insert generateInsert(String table, String[] columns, boolean ifNotExists, Integer ttl) {
        InsertInto into = QueryBuilder.insertInto((String)table);
        InsertInto regularInsert = null;
        Insert insert = null;
        for (String column : columns) {
            regularInsert = (regularInsert != null ? regularInsert : into).value(column, (Term)QueryBuilder.bindMarker());
        }
        if (ifNotExists) {
            insert = regularInsert.ifNotExists();
        }
        if (ttl != null) {
            insert = (insert != null ? insert : regularInsert).usingTtl(ttl.intValue());
        }
        return insert != null ? insert : regularInsert;
    }

    public static Select generateSelect(String table, String[] selectColumns, String[] whereColumns) {
        return CassandraUtils.generateSelect(table, selectColumns, whereColumns, CassandraUtils.size(whereColumns));
    }

    public static Select generateSelect(String table, String[] selectColumns, String[] whereColumns, int whereColumnsMaxIndex) {
        SelectFrom from = QueryBuilder.selectFrom((String)table);
        Select select = null;
        for (String column : selectColumns) {
            select = (select != null ? select : from).column(column);
        }
        if (select == null) {
            select = from.all();
        }
        if (CassandraUtils.isWhereClause(whereColumns, whereColumnsMaxIndex)) {
            for (int i = 0; i < whereColumns.length && i < whereColumnsMaxIndex; ++i) {
                select = (Select)select.whereColumn(whereColumns[i]).isEqualTo((Term)QueryBuilder.bindMarker());
            }
        }
        return select;
    }

    public static Delete generateDelete(String table, String[] whereColumns, boolean ifExists) {
        return CassandraUtils.generateDelete(table, whereColumns, CassandraUtils.size(whereColumns), ifExists);
    }

    public static Delete generateDelete(String table, String[] whereColumns, int whereColumnsMaxIndex, boolean ifExists) {
        DeleteSelection deleteSelection = QueryBuilder.deleteFrom((String)table);
        DeleteSelection delete = null;
        if (CassandraUtils.isWhereClause(whereColumns, whereColumnsMaxIndex)) {
            for (int i = 0; i < whereColumns.length && i < whereColumnsMaxIndex; ++i) {
                delete = (Delete)(delete != null ? delete : deleteSelection).whereColumn(whereColumns[i]).isEqualTo((Term)QueryBuilder.bindMarker());
            }
        } else {
            throw new IllegalArgumentException("Invalid delete statement. There has to be at least one relation. To delete all records, use Truncate");
        }
        if (ifExists) {
            delete = (Delete)delete.ifExists();
        }
        return delete;
    }

    private static boolean isWhereClause(String[] whereColumns, int whereColumnsMaxIndex) {
        return !CassandraUtils.isEmpty(whereColumns) && whereColumnsMaxIndex > 0;
    }

    public static Truncate generateTruncate(String table) {
        Truncate truncate = QueryBuilder.truncate((String)table);
        return truncate;
    }

    public static <T extends SimpleStatement> T applyConsistencyLevel(T statement, ConsistencyLevel consistencyLevel) {
        if (consistencyLevel != null) {
            statement.setConsistencyLevel(consistencyLevel);
        }
        return statement;
    }
}

