/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;

public final class SackStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final Supplier initialValue;
    private final UnaryOperator splitOperator;
    private final BinaryOperator mergeOperator;

    private SackStrategy(Supplier initialValue, UnaryOperator splitOperator, BinaryOperator mergeOperator) {
        if (null == initialValue) {
            throw new IllegalArgumentException("The initial value of a sack can not be null");
        }
        this.initialValue = initialValue;
        this.splitOperator = splitOperator;
        this.mergeOperator = mergeOperator;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getParent() instanceof EmptyStep) {
            traversal.getSideEffects().setSack(this.initialValue, this.splitOperator, this.mergeOperator);
        }
    }

    public static <A> Builder<A> build() {
        return new Builder();
    }

    public static final class Builder<A> {
        private Supplier<A> initialValue;
        private UnaryOperator<A> splitOperator = null;
        private BinaryOperator<A> mergeOperator = null;

        private Builder() {
        }

        public Builder initialValue(Supplier<A> initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder splitOperator(UnaryOperator<A> splitOperator) {
            this.splitOperator = splitOperator;
            return this;
        }

        public Builder mergeOperator(BinaryOperator<A> mergeOperator) {
            this.mergeOperator = mergeOperator;
            return this;
        }

        public SackStrategy create() {
            return new SackStrategy(this.initialValue, this.splitOperator, this.mergeOperator);
        }
    }
}

