/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.ConsulAgentProducer;
import org.apache.camel.component.consul.endpoint.ConsulCatalogProducer;
import org.apache.camel.component.consul.endpoint.ConsulCoordinatesProducer;
import org.apache.camel.component.consul.endpoint.ConsulEventConsumer;
import org.apache.camel.component.consul.endpoint.ConsulEventProducer;
import org.apache.camel.component.consul.endpoint.ConsulHealthProducer;
import org.apache.camel.component.consul.endpoint.ConsulKeyValueConsumer;
import org.apache.camel.component.consul.endpoint.ConsulKeyValueProducer;
import org.apache.camel.component.consul.endpoint.ConsulPreparedQueryProducer;
import org.apache.camel.component.consul.endpoint.ConsulSessionProducer;
import org.apache.camel.component.consul.endpoint.ConsulStatusProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;

@Component(value="consul")
public class ConsulComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private ConsulConfiguration configuration = new ConsulConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public ConsulComponent() {
    }

    public ConsulComponent(CamelContext context) {
        super(context);
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public void setUrl(String url) {
        this.configuration.setUrl(url);
    }

    public String getDatacenter() {
        return this.configuration.getDatacenter();
    }

    public void setDatacenter(String datacenter) {
        this.configuration.setDatacenter(datacenter);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getAclToken() {
        return this.configuration.getAclToken();
    }

    public void setAclToken(String aclToken) {
        this.configuration.setAclToken(aclToken);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public ConsulConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConsulConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ConsulConfiguration configuration = Optional.ofNullable(this.configuration).orElseGet(ConsulConfiguration::new).copy();
        ConsulEndpoint endpoint = null;
        switch (remaining) {
            case "kv": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulKeyValueProducer::new), Optional.of(ConsulKeyValueConsumer::new));
                break;
            }
            case "event": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulEventProducer::new), Optional.of(ConsulEventConsumer::new));
                break;
            }
            case "agent": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulAgentProducer::new), Optional.empty());
                break;
            }
            case "coordinates": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulCoordinatesProducer::new), Optional.empty());
                break;
            }
            case "health": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulHealthProducer::new), Optional.empty());
                break;
            }
            case "status": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulStatusProducer::new), Optional.empty());
                break;
            }
            case "preparedQuery": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulPreparedQueryProducer::new), Optional.empty());
                break;
            }
            case "catalog": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulCatalogProducer::new), Optional.empty());
                break;
            }
            case "session": {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulSessionProducer::new), Optional.empty());
                break;
            }
            default: {
                endpoint = new ConsulEndpoint(remaining, uri, this, configuration, Optional.of(ConsulKeyValueProducer::new), Optional.of(ConsulKeyValueConsumer::new));
            }
        }
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }
}

