/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Provider;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;

public class ThreadLocalKeyFactory
extends ThreadLocalCrypto<KeyFactory> {
    public ThreadLocalKeyFactory(final String algorithm) {
        super(new ThreadLocalCrypto.Factory<KeyFactory>(){

            @Override
            public KeyFactory getInstance() throws GeneralSecurityException {
                Provider provider;
                String oid = Asn1DerDecoder.getEdDsaStandardAlgorithmName((String)algorithm, null);
                if (oid != null && (provider = Asn1DerDecoder.getEdDsaProvider()) != null) {
                    return KeyFactory.getInstance(oid, provider);
                }
                return KeyFactory.getInstance(algorithm);
            }
        });
    }
}

