/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.StringUtil;

public class Request
extends Message {
    private static final Pattern IP_PATTERN = Pattern.compile("(\\[[0-9a-f:]+(%\\w+)?\\]|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
    private final CoAP.Code code;
    private boolean multicast;
    private Response response;
    private String scheme;
    @Deprecated
    private InetAddress destination;
    @Deprecated
    private int destinationPort;
    private Map<String, String> userContext;

    public Request(CoAP.Code code) {
        this(code, CoAP.Type.CON);
    }

    public Request(CoAP.Code code, CoAP.Type type) {
        super(type);
        this.code = code;
    }

    public CoAP.Code getCode() {
        return this.code;
    }

    @Override
    public int getRawCode() {
        return this.code == null ? 0 : this.code.value;
    }

    public String getScheme() {
        return this.scheme == null ? "coap" : this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    @Override
    public boolean isIntendedPayload() {
        return this.code != CoAP.Code.GET && this.code != CoAP.Code.DELETE;
    }

    @Override
    public Request setPayload(String payload) {
        super.setPayload(payload);
        return this;
    }

    @Override
    public Request setPayload(byte[] payload) {
        super.setPayload(payload);
        return this;
    }

    public Request setURI(String uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        try {
            String coapUri = uri;
            if (!uri.contains("://")) {
                coapUri = "coap://" + uri;
                LOGGER.warn("update your code to supply an RFC 7252 compliant URI including a scheme");
            }
            return this.setURI(new URI(coapUri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid uri: " + uri, e);
        }
    }

    public Request setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        String host = uri.getHost() == null ? "localhost" : uri.getHost();
        try {
            if (this.getDestinationContext() == null) {
                InetAddress destAddress = InetAddress.getByName(host);
                this.setDestinationContext((EndpointContext)new AddressEndpointContext(new InetSocketAddress(destAddress, 0), null));
            }
            return this.setOptions(new URI(uri.getScheme(), uri.getUserInfo(), host, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("cannot resolve host name: " + host);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("cannot set URI on request", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public Request setOptions(URI uri) {
        String query;
        EndpointContext destinationContext;
        InetAddress destination = this.getDestination();
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        if (!CoAP.isSupportedScheme(uri.getScheme())) {
            throw new IllegalArgumentException("unsupported URI scheme: " + uri.getScheme());
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI must not contain a fragment");
        }
        if (destination == null) {
            throw new IllegalStateException("destination address must be set");
        }
        if (uri.getHost() != null) {
            String host = uri.getHost().toLowerCase();
            Matcher matcher = IP_PATTERN.matcher(host);
            if (matcher.matches()) {
                try {
                    InetAddress hostAddress = InetAddress.getByName(host);
                    if (!hostAddress.equals(destination)) {
                        throw new IllegalArgumentException("URI's literal host IP address '" + hostAddress + "' does not match request's destination address '" + destination + "'");
                    }
                }
                catch (UnknownHostException e) {
                    LOGGER.warn("could not parse IP address of URI despite successful IP address pattern matching");
                }
            } else if (StringUtil.isValidHostName((String)host)) {
                this.getOptions().setUriHost(host);
            } else {
                throw new IllegalArgumentException("URI's hostname '" + host + "' is invalid!'");
            }
        }
        String uriScheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        if (port <= 0) {
            port = CoAP.getDefaultPort(uriScheme);
        }
        if ((destinationContext = this.getDestinationContext()) != null) {
            int destPort = destinationContext.getPeerAddress().getPort();
            if (destPort == 0) {
                destinationContext = null;
            } else if (destPort != port) {
                throw new IllegalArgumentException("URI's port '" + port + "' does not match request's destination port '" + destPort + "'");
            }
        }
        if (destinationContext == null) {
            this.setDestinationContext((EndpointContext)new AddressEndpointContext(new InetSocketAddress(destination, port), this.getOptions().getUriHost(), null));
        }
        this.scheme = uriScheme;
        String path = uri.getPath();
        if (path != null && path.length() > 1) {
            this.getOptions().setUriPath(path);
        }
        if ((query = uri.getQuery()) != null) {
            this.getOptions().setUriQuery(query);
        }
        return this;
    }

    public String getURI() {
        Integer port;
        String host = this.getOptions().getUriHost();
        if (host == null) {
            host = this.getDestination() != null ? this.getDestination().getHostAddress() : "localhost";
        }
        if ((port = this.getOptions().getUriPort()) == null) {
            port = this.getDestinationPort();
        }
        if (port > 0) {
            if (CoAP.isSupportedScheme(this.getScheme()) && CoAP.getDefaultPort(this.getScheme()) == port) {
                port = -1;
            }
        } else {
            port = -1;
        }
        String path = "/" + this.getOptions().getUriPathString();
        String query = this.getOptions().getURIQueryCount() > 0 ? this.getOptions().getUriQueryString() : null;
        try {
            URI uri = new URI(this.getScheme(), null, host, port, path, query, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("cannot create URI from request", e);
        }
    }

    @Override
    public InetAddress getDestination() {
        EndpointContext context = this.getDestinationContext();
        if (context != null) {
            return context.getPeerAddress().getAddress();
        }
        return this.destination;
    }

    public Message setDestination(InetAddress destination) {
        if (this.getDestinationContext() != null) {
            throw new IllegalStateException("destination context already set!");
        }
        this.destination = destination;
        this.multicast = destination != null && destination.isMulticastAddress();
        return this;
    }

    @Override
    public int getDestinationPort() {
        EndpointContext context = this.getDestinationContext();
        if (context != null) {
            return context.getPeerAddress().getPort();
        }
        return this.destinationPort;
    }

    public Message setDestinationPort(int destinationPort) {
        if (this.getDestinationContext() != null) {
            throw new IllegalStateException("destination context already set!");
        }
        this.destinationPort = destinationPort;
        return this;
    }

    public Principal getSenderIdentity() {
        return this.getSourceContext().getPeerIdentity();
    }

    public void prepareDestinationContext() {
        EndpointContext context = this.getDestinationContext();
        if (context == null) {
            if (this.destination == null) {
                throw new IllegalStateException("missing destination!");
            }
            context = new AddressEndpointContext(new InetSocketAddress(this.destination, this.destinationPort), this.getOptions().getUriHost(), null);
            super.setDestinationContext(context);
        }
        this.multicast = context.getPeerAddress().getAddress().isMulticastAddress();
    }

    @Override
    public Request setDestinationContext(EndpointContext peerContext) {
        if (this.destination != null && !this.destination.equals(peerContext.getPeerAddress().getAddress())) {
            throw new IllegalStateException("different destination!");
        }
        super.setRequestDestinationContext(peerContext);
        this.multicast = peerContext != null && peerContext.getPeerAddress().getAddress().isMulticastAddress();
        return this;
    }

    public Request send() {
        this.validateBeforeSending();
        EndpointManager.getEndpointManager().getDefaultEndpoint(this.getScheme()).sendRequest(this);
        return this;
    }

    public Request send(Endpoint endpoint) {
        this.validateBeforeSending();
        endpoint.sendRequest(this);
        return this;
    }

    private void validateBeforeSending() {
        if (this.getDestination() == null) {
            throw new NullPointerException("Destination is null");
        }
        if (this.getDestinationPort() == 0) {
            throw new NullPointerException("Destination port is 0");
        }
    }

    public final Request setObserve() {
        if (!CoAP.isObservable(this.code)) {
            throw new IllegalStateException("observe option can only be set on a GET or FETCH request");
        }
        this.getOptions().setObserve(0);
        return this;
    }

    public final boolean isObserve() {
        return this.isObserveOption(0);
    }

    public final Request setObserveCancel() {
        if (!CoAP.isObservable(this.code)) {
            throw new IllegalStateException("observe option can only be set on a GET or FETCH request");
        }
        this.getOptions().setObserve(1);
        return this;
    }

    public final boolean isObserveCancel() {
        return this.isObserveOption(1);
    }

    private final boolean isObserveOption(int observe) {
        Integer optionObserver = this.getOptions().getObserve();
        return optionObserver != null && optionObserver == observe;
    }

    public synchronized Response getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Response response) {
        Request request = this;
        synchronized (request) {
            this.response = response;
            this.notifyAll();
        }
        for (MessageObserver handler : this.getMessageObservers()) {
            handler.onResponse(response);
        }
    }

    public Response waitForResponse() throws InterruptedException {
        return this.waitForResponse(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForResponse(long timeout) throws InterruptedException {
        long expiresNano = ClockUtil.nanoRealtime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        long leftTimeout = timeout;
        Request request = this;
        synchronized (request) {
            while (!(this.response != null || this.isCanceled() || this.isTimedOut() || this.isRejected() || this.getSendError() != null)) {
                this.wait(leftTimeout);
                if (timeout <= 0L) continue;
                long leftNanos = expiresNano - ClockUtil.nanoRealtime();
                if (leftNanos <= 0L) break;
                leftTimeout = TimeUnit.NANOSECONDS.toMillis(leftNanos) + 1L;
            }
            Response r = this.response;
            this.response = null;
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimedOut(boolean timedOut) {
        super.setTimedOut(timedOut);
        if (timedOut) {
            Request request = this;
            synchronized (request) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        if (canceled) {
            Request request = this;
            synchronized (request) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRejected(boolean rejected) {
        super.setRejected(rejected);
        if (rejected) {
            Request request = this;
            synchronized (request) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSendError(Throwable sendError) {
        super.setSendError(sendError);
        if (sendError != null) {
            Request request = this;
            synchronized (request) {
                this.notifyAll();
            }
        }
    }

    public Map<String, String> getUserContext() {
        return this.userContext;
    }

    public Request setUserContext(Map<String, String> userContext) {
        this.userContext = userContext == null || userContext.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(userContext));
        return this;
    }

    public String toString() {
        String payload = this.getPayloadTracingString();
        return String.format("%s-%-6s MID=%5d, Token=%s, OptionSet=%s, %s", new Object[]{this.getType(), this.getCode(), this.getMID(), this.getTokenString(), this.getOptions(), payload});
    }

    public static Request newGet() {
        return new Request(CoAP.Code.GET);
    }

    public static Request newPost() {
        return new Request(CoAP.Code.POST);
    }

    public static Request newPut() {
        return new Request(CoAP.Code.PUT);
    }

    public static Request newDelete() {
        return new Request(CoAP.Code.DELETE);
    }
}

