/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import java.security.GeneralSecurityException;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloseOnErrorHandler
extends ChannelHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseOnErrorHandler.class);

    CloseOnErrorHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            Throwable rootCause = cause;
            while (null != rootCause.getCause()) {
                rootCause = rootCause.getCause();
            }
            if (!LOGGER.isDebugEnabled() && (rootCause instanceof SSLException || rootCause instanceof GeneralSecurityException)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.error("Security Exception in channel handler chain for endpoint {}. Closing connection.", (Object)ctx.channel().remoteAddress(), (Object)rootCause);
                } else {
                    LOGGER.error("{} in channel handler chain for endpoint {}. Closing connection.", (Object)rootCause, (Object)ctx.channel().remoteAddress());
                }
            } else if (!LOGGER.isDebugEnabled() && rootCause instanceof RejectedExecutionException) {
                LOGGER.error("{} in channel handler chain for endpoint {}. Closing connection.", (Object)rootCause, (Object)ctx.channel().remoteAddress());
            } else {
                LOGGER.error("Exception in channel handler chain for endpoint {}. Closing connection.", (Object)ctx.channel().remoteAddress(), (Object)cause);
            }
        }
        finally {
            ctx.close();
        }
    }
}

