/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;

public final class SignatureAndHashAlgorithm {
    public static SignatureAndHashAlgorithm SHA1_WITH_ECDSA = new SignatureAndHashAlgorithm(HashAlgorithm.SHA1, SignatureAlgorithm.ECDSA);
    public static SignatureAndHashAlgorithm SHA256_WITH_ECDSA = new SignatureAndHashAlgorithm(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA);
    public static SignatureAndHashAlgorithm SHA384_WITH_ECDSA = new SignatureAndHashAlgorithm(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA);
    public static SignatureAndHashAlgorithm SHA256_WITH_RSA = new SignatureAndHashAlgorithm(HashAlgorithm.SHA256, SignatureAlgorithm.RSA);
    public static SignatureAndHashAlgorithm INTRINSIC_WITH_ED25519 = new SignatureAndHashAlgorithm(HashAlgorithm.INTRINSIC, SignatureAlgorithm.ED25519);
    public static SignatureAndHashAlgorithm INTRINSIC_WITH_ED448 = new SignatureAndHashAlgorithm(HashAlgorithm.INTRINSIC, SignatureAlgorithm.ED448);
    public static List<SignatureAndHashAlgorithm> DEFAULT = Collections.unmodifiableList(Arrays.asList(SHA256_WITH_ECDSA, SHA256_WITH_RSA));
    private final String jcaName;
    private final HashAlgorithm hash;
    private final SignatureAlgorithm signature;
    private final int hashAlgorithmCode;
    private final int signatureAlgorithmCode;
    private final boolean supported;

    public static ThreadLocalSignature getThreadLocalSignature(String algorithm) {
        if (algorithm == null) {
            algorithm = "UNKNOWN";
        }
        return ThreadLocalSignature.SIGNATURES.get(algorithm);
    }

    public static SignatureAndHashAlgorithm valueOf(String jcaName) {
        int index = jcaName.indexOf("with");
        if (index < 0) {
            index = jcaName.indexOf("WITH");
        }
        if (0 < index) {
            String hash = jcaName.substring(0, index);
            String signature = jcaName.substring(index + 4, jcaName.length());
            HashAlgorithm hashAlgorithm = HashAlgorithm.valueOf(hash);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.valueOf(signature);
            if (hashAlgorithm != null && signatureAlgorithm != null) {
                return new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
            }
        }
        return null;
    }

    public static List<SignatureAndHashAlgorithm> getDefaultSignatureAlgorithms(List<X509Certificate> certificateChain) {
        if (certificateChain != null && certificateChain.size() > 0) {
            PublicKey publicKey = certificateChain.get(0).getPublicKey();
            List<SignatureAndHashAlgorithm> result = SignatureAndHashAlgorithm.getDefaultSignatureAlgorithms(publicKey);
            for (X509Certificate certificate : certificateChain) {
                String sigAlgName = certificate.getSigAlgName();
                SignatureAndHashAlgorithm signature = SignatureAndHashAlgorithm.valueOf(sigAlgName);
                if (signature == null || result.contains(signature)) continue;
                result.add(signature);
            }
            return result;
        }
        return new ArrayList<SignatureAndHashAlgorithm>(DEFAULT);
    }

    public static List<SignatureAndHashAlgorithm> getDefaultSignatureAlgorithms(PublicKey publicKey) {
        ArrayList<SignatureAndHashAlgorithm> result = new ArrayList<SignatureAndHashAlgorithm>(DEFAULT);
        if (publicKey != null && SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(result, publicKey) == null) {
            for (HashAlgorithm hashAlgorithm : HashAlgorithm.values()) {
                if (hashAlgorithm.equals((Object)HashAlgorithm.NONE)) continue;
                for (SignatureAlgorithm signatureAlgorithm : SignatureAlgorithm.values()) {
                    SignatureAndHashAlgorithm signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
                    Signature signature = (Signature)signAndHash.getThreadLocalSignature().current();
                    if (signature == null) continue;
                    try {
                        signature.initVerify(publicKey);
                        if (!result.contains(signAndHash)) {
                            result.add(signAndHash);
                        }
                        return result;
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    public static List<SignatureAndHashAlgorithm> getCommonSignatureAlgorithms(List<SignatureAndHashAlgorithm> proposedSignatureAndHashAlgorithms, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms) {
        ArrayList<SignatureAndHashAlgorithm> result = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm algo : proposedSignatureAndHashAlgorithms) {
            if (!supportedSignatureAndHashAlgorithms.contains(algo)) continue;
            result.add(algo);
        }
        return result;
    }

    public static SignatureAndHashAlgorithm getSupportedSignatureAlgorithm(List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms, PublicKey key) {
        if (key == null) {
            throw new NullPointerException("Public key must not be null!");
        }
        for (SignatureAndHashAlgorithm supportedAlgorithm : supportedSignatureAlgorithms) {
            try {
                Signature sign = (Signature)supportedAlgorithm.getThreadLocalSignature().current();
                if (sign == null) continue;
                sign.initVerify(key);
                return supportedAlgorithm;
            }
            catch (InvalidKeyException invalidKeyException) {
            }
        }
        return null;
    }

    public static List<SignatureAndHashAlgorithm> getEcdsaCompatibleSignatureAlgorithms(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        ArrayList<SignatureAndHashAlgorithm> result = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm algo : signatureAndHashAlgorithms) {
            if (!algo.getSignature().isEcdsaCompatible()) continue;
            result.add(algo);
        }
        return result;
    }

    public static boolean isSignedWithSupportedAlgorithms(List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms, List<X509Certificate> certificateChain) {
        for (X509Certificate certificate : certificateChain) {
            if (SignatureAndHashAlgorithm.isSignedWithSupportedAlgorithm(supportedSignatureAlgorithms, certificate)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSignedWithSupportedAlgorithm(List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms, X509Certificate certificate) {
        String sigAlgName = certificate.getSigAlgName();
        for (SignatureAndHashAlgorithm supportedAlgorithm : supportedSignatureAlgorithms) {
            if (!supportedAlgorithm.getJcaName().equalsIgnoreCase(sigAlgName)) continue;
            return true;
        }
        return false;
    }

    public SignatureAndHashAlgorithm(HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm) {
        if (hashAlgorithm == null) {
            throw new NullPointerException("Hash Algorithm must not be null!");
        }
        if (signatureAlgorithm == null) {
            throw new NullPointerException("Signature Algorithm must not be null!");
        }
        this.hash = hashAlgorithm;
        this.signature = signatureAlgorithm;
        this.hashAlgorithmCode = hashAlgorithm.getCode();
        this.signatureAlgorithmCode = signatureAlgorithm.getCode();
        this.jcaName = this.buildJcaName();
        this.supported = this.jcaName != null && SignatureAndHashAlgorithm.getThreadLocalSignature(this.jcaName).isSupported();
    }

    public SignatureAndHashAlgorithm(int hashAlgorithmCode, int signatureAlgorithmCode) {
        this.hashAlgorithmCode = hashAlgorithmCode;
        this.signatureAlgorithmCode = signatureAlgorithmCode;
        this.signature = SignatureAlgorithm.getAlgorithmByCode(signatureAlgorithmCode);
        this.hash = HashAlgorithm.getAlgorithmByCode(hashAlgorithmCode);
        this.jcaName = this.buildJcaName();
        this.supported = this.jcaName != null && SignatureAndHashAlgorithm.getThreadLocalSignature(this.jcaName).isSupported();
    }

    private String buildJcaName() {
        if (this.hash != null && this.signature != null) {
            StringBuilder name = new StringBuilder();
            if (this.hash != HashAlgorithm.INTRINSIC) {
                name.append((Object)this.hash);
                name.append("with");
            }
            name.append((Object)this.signature);
            return name.toString();
        }
        return null;
    }

    public SignatureAlgorithm getSignature() {
        return this.signature;
    }

    public HashAlgorithm getHash() {
        return this.hash;
    }

    public String getJcaName() {
        return this.jcaName;
    }

    @Deprecated
    public String jcaName() {
        return this.jcaName;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public String toString() {
        if (this.jcaName != null) {
            return this.jcaName;
        }
        StringBuilder result = new StringBuilder();
        if (this.hash != null) {
            result.append((Object)this.hash);
        } else {
            result.append(String.format("0x%02x", this.hashAlgorithmCode));
        }
        result.append("with");
        if (this.signature != null) {
            result.append((Object)this.signature);
        } else {
            result.append(String.format("0x%02x", this.signatureAlgorithmCode));
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureAndHashAlgorithm other = (SignatureAndHashAlgorithm)obj;
        return this.signatureAlgorithmCode == other.signatureAlgorithmCode && this.hashAlgorithmCode == other.hashAlgorithmCode;
    }

    public int hashCode() {
        return this.hashAlgorithmCode * 100 + this.signatureAlgorithmCode;
    }

    public ThreadLocalSignature getThreadLocalSignature() {
        return SignatureAndHashAlgorithm.getThreadLocalSignature(this.getJcaName());
    }

    public static enum SignatureAlgorithm {
        ANONYMOUS(0, false),
        RSA(1, false),
        DSA(2, false),
        ECDSA(3, true),
        ED25519(7, true),
        ED448(8, true);

        private final int code;
        private final boolean isEcdsaCompatible;

        private SignatureAlgorithm(int code, boolean ecdsa) {
            this.code = code;
            this.isEcdsaCompatible = ecdsa;
        }

        public static SignatureAlgorithm getAlgorithmByCode(int code) {
            switch (code) {
                case 0: {
                    return ANONYMOUS;
                }
                case 1: {
                    return RSA;
                }
                case 2: {
                    return DSA;
                }
                case 3: {
                    return ECDSA;
                }
                case 7: {
                    return ED25519;
                }
                case 8: {
                    return ED448;
                }
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }

        public boolean isEcdsaCompatible() {
            return this.isEcdsaCompatible;
        }
    }

    public static enum HashAlgorithm {
        NONE(0),
        MD5(1),
        SHA1(2),
        SHA224(3),
        SHA256(4),
        SHA384(5),
        SHA512(6),
        INTRINSIC(8);

        private int code;

        private HashAlgorithm(int code) {
            this.code = code;
        }

        public static HashAlgorithm getAlgorithmByCode(int code) {
            switch (code) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return MD5;
                }
                case 2: {
                    return SHA1;
                }
                case 3: {
                    return SHA224;
                }
                case 4: {
                    return SHA256;
                }
                case 5: {
                    return SHA384;
                }
                case 6: {
                    return SHA512;
                }
                case 8: {
                    return INTRINSIC;
                }
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }
}

