/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockwiseStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockwiseStatus.class);
    private final int contentFormat;
    protected boolean randomAccess;
    protected final ByteBuffer buf;
    protected Exchange exchange;
    protected EndpointContext followUpEndpointContext;
    private ScheduledFuture<?> cleanUpTask;
    private Message first;
    private int currentNum;
    private int currentSzx;
    private boolean complete;
    private int blockCount;

    protected BlockwiseStatus(int maxSize, int contentFormat) {
        this.buf = ByteBuffer.allocate(maxSize);
        this.contentFormat = contentFormat;
    }

    protected BlockwiseStatus(int contentFormat, int num, int szx) {
        this(0, contentFormat);
        this.currentNum = num;
        this.currentSzx = szx;
    }

    final synchronized void setFirst(Message first) {
        this.first = first;
        this.first.setProtectFromOffload();
    }

    public final synchronized int getCurrentNum() {
        return this.currentNum;
    }

    public final synchronized void setCurrentNum(int currentNum) {
        this.currentNum = currentNum;
    }

    public final synchronized int getCurrentSzx() {
        return this.currentSzx;
    }

    public final synchronized int getCurrentSize() {
        return BlockOption.szx2Size(this.currentSzx);
    }

    final synchronized void setCurrentSzx(int currentSzx) {
        this.currentSzx = currentSzx;
    }

    public final boolean hasContentFormat(int format) {
        return this.contentFormat == format;
    }

    public final synchronized boolean isComplete() {
        return this.complete;
    }

    public final synchronized void setComplete(boolean complete) {
        this.complete = complete;
        if (complete && this.cleanUpTask != null) {
            this.cleanUpTask.cancel(false);
            this.cleanUpTask = null;
        }
    }

    public final synchronized boolean addBlock(byte[] block) {
        boolean result = false;
        if (block == null) {
            result = true;
        } else if (block != null && this.buf.remaining() >= block.length) {
            result = true;
            this.buf.put(block);
        } else {
            LOGGER.debug("resource body exceeds buffer size [{}]", (Object)this.getBufferSize());
        }
        ++this.blockCount;
        return result;
    }

    public final synchronized int getBufferSize() {
        return this.buf.capacity();
    }

    final synchronized int getBlockCount() {
        return this.blockCount;
    }

    final synchronized byte[] getBody() {
        ((Buffer)this.buf).flip();
        byte[] body = new byte[this.buf.remaining()];
        ((Buffer)this.buf.get(body)).clear();
        return body;
    }

    synchronized EndpointContext getFollowUpEndpointContext(EndpointContext blockContext) {
        if (this.followUpEndpointContext == null || !this.followUpEndpointContext.getPeerAddress().equals(blockContext.getPeerAddress())) {
            if (this.exchange != null) {
                Request request = this.exchange.getRequest();
                EndpointContext messageContext = request.getDestinationContext();
                this.followUpEndpointContext = EndpointContextUtil.getFollowUpEndpointContext((EndpointContext)messageContext, (EndpointContext)blockContext);
            } else {
                this.followUpEndpointContext = blockContext;
            }
        }
        return this.followUpEndpointContext;
    }

    public synchronized String toString() {
        return String.format("[currentNum=%d, currentSzx=%d, bufferSize=%d, complete=%b, random access=%b]", this.currentNum, this.currentSzx, this.getBufferSize(), this.complete, this.randomAccess);
    }

    public final synchronized boolean isRandomAccess() {
        return this.randomAccess;
    }

    public final synchronized void assembleReceivedMessage(Message message) {
        if (message == null) {
            throw new NullPointerException("message must not be null");
        }
        if (this.first == null) {
            throw new IllegalStateException("first message is not set");
        }
        if (this.first.getSourceContext() == null) {
            throw new IllegalStateException("first message has no peer context");
        }
        if (this.first.getSourceContext().getPeerAddress() == null) {
            throw new IllegalStateException("first message has no peer address");
        }
        message.setSourceContext(this.first.getSourceContext());
        message.setType(this.first.getType());
        message.setMID(this.first.getMID());
        message.setToken(this.first.getToken());
        message.setOptions(new OptionSet(this.first.getOptions()));
        message.getOptions().removeBlock1();
        message.getOptions().removeBlock2();
        if (!message.isIntendedPayload()) {
            message.setUnintendedPayload();
        }
        message.setPayload(this.getBody());
    }

    public final synchronized void setBlockCleanupHandle(ScheduledFuture<?> blockCleanupHandle) {
        if (this.cleanUpTask != null) {
            this.cleanUpTask.cancel(false);
        }
        this.cleanUpTask = blockCleanupHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutCurrentTranfer() {
        Exchange exchange;
        BlockwiseStatus blockwiseStatus = this;
        synchronized (blockwiseStatus) {
            exchange = this.exchange;
        }
        if (exchange != null && !exchange.isComplete()) {
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    exchange.setTimedOut(exchange.getCurrentRequest());
                }
            });
        }
    }
}

