/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhEcdsaServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteParameters;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;

@NoPublicAPI
public class ServerHandshaker
extends Handshaker {
    private static HandshakeState[] CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_VERIFY), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static HandshakeState[] EMPTY_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    protected static HandshakeState[] NO_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private boolean useNoSessionId = false;
    private boolean clientAuthenticationWanted = false;
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private CipherSuiteSelector cipherSuiteSelector;
    private List<CipherSuite> supportedCipherSuites;
    protected final List<XECDHECryptography.SupportedGroup> supportedGroups;
    private final List<CertificateType> supportedClientCertificateTypes;
    private final List<CertificateType> supportedServerCertificateTypes;
    private final List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms;
    private CipherSuiteParameters selectedCipherSuiteParameters;
    private CertificateMessage clientCertificate = null;
    private CertificateVerify certificateVerify = null;
    private PskPublicInformation preSharedKeyIdentity;
    private XECDHECryptography ecdhe;

    public ServerHandshaker(int initialMessageSequenceNo, DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        super(false, initialMessageSequenceNo, session, recordLayer, timer, connection, config);
        this.cipherSuiteSelector = config.getCipherSuiteSelector();
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.supportedGroups = config.getSupportedGroups();
        this.clientAuthenticationWanted = config.isClientAuthenticationWanted();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.useNoSessionId = config.useNoServerSessionId();
        this.supportedClientCertificateTypes = config.getTrustCertificateTypes();
        this.supportedServerCertificateTypes = config.getIdentityCertificateTypes();
        this.supportedSignatureAndHashAlgorithms = config.getSupportedSignatureAlgorithms();
    }

    public PskPublicInformation getPreSharedKeyIdentity() {
        return this.preSharedKeyIdentity;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException, GeneralSecurityException {
        block0 : switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.receivedClientHello((ClientHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedClientCertificate((CertificateMessage)message);
                break;
            }
            case CLIENT_KEY_EXCHANGE: {
                switch (this.session.getKeyExchange()) {
                    case PSK: {
                        PskSecretResult masterSecretResult = this.receivedClientKeyExchange((PSKClientKeyExchange)message);
                        if (masterSecretResult == null) break block0;
                        this.processPskSecretResult(masterSecretResult);
                        break block0;
                    }
                    case ECDHE_PSK: {
                        PskSecretResult masterSecretResult = this.receivedClientKeyExchange((EcdhPskClientKeyExchange)message);
                        if (masterSecretResult == null) break block0;
                        this.processPskSecretResult(masterSecretResult);
                        break block0;
                    }
                    case EC_DIFFIE_HELLMAN: {
                        SecretKey masterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)message);
                        this.processMasterSecret(masterSecret);
                        break block0;
                    }
                    default: {
                        throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.session.getKeyExchange().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
                    }
                }
            }
            case CERTIFICATE_VERIFY: {
                this.receivedCertificateVerify((CertificateVerify)message);
                if (this.masterSecret == null) break;
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getMessageType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, message.getPeer()));
            }
        }
    }

    @Override
    protected void processMasterSecret(SecretKey masterSecret) throws HandshakeException {
        this.applyMasterSecret(masterSecret);
        SecretUtil.destroy(masterSecret);
        if (!this.clientAuthenticationRequired || this.session.getKeyExchange() != CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN || this.certificateVerify != null) {
            this.expectChangeCipherSpecMessage();
        }
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        this.clientCertificate = message;
        this.clientPublicKey = message.getPublicKey();
        if (this.clientAuthenticationRequired && message.getCertificateChain() != null && this.clientPublicKey == null) {
            this.LOGGER.debug("Client authentication failed: missing certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client Certificate required!", alert);
        }
        this.verifyCertificate(message);
        if (this.clientPublicKey == null) {
            this.states = EMPTY_CLIENT_CERTIFICATE;
        }
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        this.handshakeMessages.remove(this.handshakeMessages.size() - 1);
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
        this.handshakeMessages.add(message);
        if (this.peerCertPath != null) {
            this.session.setPeerIdentity((Principal)new X509CertPath(this.peerCertPath));
        } else {
            this.session.setPeerIdentity((Principal)new RawPublicKeyIdentity(this.clientPublicKey));
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        MessageDigest mdWithClientFinished;
        if (CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.session.getKeyExchange()) && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        this.flightNumber += 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithClientFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        message.verifyData(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, true, md.digest());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        mdWithClientFinished.update(message.toByteArray());
        Finished finished = new Finished(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, this.isClient, mdWithClientFinished.digest(), this.session.getPeer());
        this.wrapMessage(flight, finished);
        this.sendLastFlight(flight);
        this.sessionEstablished();
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        this.handshakeStarted();
        byte[] cookie = clientHello.getCookie();
        this.flightNumber = cookie != null && cookie.length > 0 ? 4 : 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        this.createServerHello(clientHello, flight);
        this.createCertificateMessage(clientHello, flight);
        this.createServerKeyExchange(clientHello, flight);
        boolean clientCertificate = this.createCertificateRequest(clientHello, flight);
        this.states = clientCertificate ? CLIENT_CERTIFICATE : NO_CLIENT_CERTIFICATE;
        this.statesIndex = -1;
        ServerHelloDone serverHelloDone = new ServerHelloDone(this.session.getPeer());
        this.wrapMessage(flight, serverHelloDone);
        this.sendFlight(flight);
    }

    private void createServerHello(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(clientHello.getClientVersion());
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        SessionId sessionId = this.useNoSessionId ? SessionId.emptySessionId() : new SessionId();
        this.session.setSessionIdentifier(sessionId);
        if (!clientHello.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, clientHello.getPeer()));
        }
        this.session.setCompressionMethod(CompressionMethod.NULL);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        this.processHelloExtensions(clientHello, serverHelloExtensions);
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, this.session.getCipherSuite(), this.session.getCompressionMethod(), serverHelloExtensions, this.session.getPeer());
        this.wrapMessage(flight, serverHello);
    }

    private void createCertificateMessage(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        CertificateMessage certificateMessage = null;
        if (this.session.getCipherSuite().requiresServerCertificateMessage()) {
            if (CertificateType.RAW_PUBLIC_KEY == this.session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.publicKey, this.session.getPeer());
            } else if (CertificateType.X_509 == this.session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.certificateChain, this.session.getPeer());
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)this.session.sendCertificateType()) + " not supported!");
            }
            this.wrapMessage(flight, certificateMessage);
        }
    }

    private void createServerKeyExchange(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ECDHServerKeyExchange serverKeyExchange = null;
        switch (this.session.getKeyExchange()) {
            case EC_DIFFIE_HELLMAN: {
                try {
                    this.ecdhe = new XECDHECryptography(this.selectedCipherSuiteParameters.getSelectedSupportedGroup());
                    serverKeyExchange = new EcdhEcdsaServerKeyExchange(this.session.getSignatureAndHashAlgorithm(), this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
            case PSK: {
                break;
            }
            case ECDHE_PSK: {
                try {
                    this.ecdhe = new XECDHECryptography(this.selectedCipherSuiteParameters.getSelectedSupportedGroup());
                    serverKeyExchange = new EcdhPskServerKeyExchange(PskPublicInformation.EMPTY, this.ecdhe, this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
        }
        if (serverKeyExchange != null) {
            this.wrapMessage(flight, serverKeyExchange);
        }
    }

    private boolean createCertificateRequest(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        if ((this.clientAuthenticationWanted || this.clientAuthenticationRequired) && this.session.getCipherSuite().requiresServerCertificateMessage() && this.selectedCipherSuiteParameters.getSelectedClientCertificateType() != null) {
            CertificateRequest certificateRequest = new CertificateRequest(this.session.getPeer());
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            if (this.session.receiveCertificateType() == CertificateType.X_509) {
                certificateRequest.addSignatureAlgorithms(this.supportedSignatureAndHashAlgorithms);
                if (this.certificateVerifier != null) {
                    List subjects = CertPathUtil.toSubjects(Arrays.asList(this.certificateVerifier.getAcceptedIssuers()));
                    certificateRequest.addCerticiateAuthorities(subjects);
                }
            } else if (this.session.receiveCertificateType() == CertificateType.RAW_PUBLIC_KEY) {
                List<SignatureAndHashAlgorithm> ecdsaSignatures = SignatureAndHashAlgorithm.getEcdsaCompatibleSignatureAlgorithms(this.supportedSignatureAndHashAlgorithms);
                certificateRequest.addSignatureAlgorithms(ecdsaSignatures);
            }
            this.wrapMessage(flight, certificateRequest);
            return true;
        }
        return false;
    }

    private SecretKey receivedClientKeyExchange(ECDHClientKeyExchange message) throws GeneralSecurityException {
        SecretKey premasterSecret = this.ecdhe.generateSecret(message.getEncodedPoint());
        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), premasterSecret, this.generateRandomSeed());
        SecretUtil.destroy(premasterSecret);
        return masterSecret;
    }

    private PskSecretResult receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.preSharedKeyIdentity = message.getIdentity();
        return this.requestPskSecretResult(this.preSharedKeyIdentity, null);
    }

    private PskSecretResult receivedClientKeyExchange(EcdhPskClientKeyExchange message) throws HandshakeException, GeneralSecurityException {
        this.preSharedKeyIdentity = message.getIdentity();
        SecretKey otherSecret = this.ecdhe.generateSecret(message.getEncodedPoint());
        PskSecretResult masterSecretRequest = this.requestPskSecretResult(this.preSharedKeyIdentity, otherSecret);
        SecretUtil.destroy(otherSecret);
        return masterSecretRequest;
    }

    protected void processHelloExtensions(ClientHello clientHello, HelloExtensions serverHelloExtensions) {
        ConnectionIdExtension connectionIdExtension;
        ServerNameExtension serverNameExt;
        MaxFragmentLengthExtension maxFragmentLengthExt;
        RecordSizeLimitExtension recordSizeLimitExt = clientHello.getRecordSizeLimitExtension();
        if (recordSizeLimitExt != null) {
            this.session.setRecordSizeLimit(recordSizeLimitExt.getRecordSizeLimit());
            int limit = this.recordSizeLimit == null ? this.session.getMaxFragmentLength() : this.recordSizeLimit.intValue();
            serverHelloExtensions.addExtension(new RecordSizeLimitExtension(limit));
            this.LOGGER.debug("Received record size limit [{} bytes] from peer [{}]", (Object)limit, (Object)clientHello.getPeer());
        }
        if (recordSizeLimitExt == null && (maxFragmentLengthExt = clientHello.getMaxFragmentLengthExtension()) != null) {
            this.session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHelloExtensions.addExtension(maxFragmentLengthExt);
            this.LOGGER.debug("Negotiated max. fragment length [{} bytes] with peer [{}]", (Object)maxFragmentLengthExt.getFragmentLength().length(), (Object)clientHello.getPeer());
        }
        if ((serverNameExt = clientHello.getServerNameExtension()) != null) {
            if (this.sniEnabled) {
                this.session.setServerNames(serverNameExt.getServerNames());
                serverHelloExtensions.addExtension(ServerNameExtension.emptyServerNameIndication());
                this.session.setSniSupported(true);
                this.LOGGER.debug("using server name indication received from peer [{}]", (Object)clientHello.getPeer());
            } else {
                this.LOGGER.debug("client [{}] included SNI in HELLO but SNI support is disabled", (Object)clientHello.getPeer());
            }
        }
        if (this.connectionIdGenerator != null && (connectionIdExtension = clientHello.getConnectionIdExtension()) != null) {
            this.session.setWriteConnectionId(connectionIdExtension.getConnectionId());
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            serverHelloExtensions.addExtension(extension);
        }
    }

    @Override
    public void startHandshake() throws HandshakeException {
        throw new HandshakeException("starting an handshake is not supported for server handshaker!", null);
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        if (clientVersion.compareTo(ProtocolVersion.VERSION_DTLS_1_2) >= 0) {
            return ProtocolVersion.VERSION_DTLS_1_2;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, this.session.getPeer());
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    protected void negotiateCipherSuite(ClientHello clientHello, HelloExtensions serverHelloExtensions) throws HandshakeException {
        CipherSuite cipherSuite;
        SupportedPointFormatsExtension.ECPointFormat format;
        List<SignatureAndHashAlgorithm> commonSignatures;
        List<XECDHECryptography.SupportedGroup> commonGroups;
        List<CertificateType> commonClientCertTypes;
        List<CertificateType> commonServerCertTypes;
        List<CipherSuite> commonCipherSuites = this.getCommonCipherSuites(clientHello);
        CipherSuiteParameters parameters = new CipherSuiteParameters(this.publicKey, this.certificateChain, this.clientAuthenticationRequired, this.clientAuthenticationWanted, commonCipherSuites, commonServerCertTypes = this.getCommonServerCertificateTypes(clientHello), commonClientCertTypes = this.getCommonClientCertificateTypes(clientHello), commonGroups = this.getCommonSupportedGroups(clientHello), commonSignatures = this.getCommonSignatureAndHashAlgorithms(clientHello), format = this.negotiateECPointFormat(clientHello));
        if (this.cipherSuiteSelector.select(parameters)) {
            this.selectedCipherSuiteParameters = parameters;
            cipherSuite = parameters.getSelectedCipherSuite();
            this.session.setCipherSuite(cipherSuite);
            if (cipherSuite.requiresServerCertificateMessage()) {
                this.session.setSignatureAndHashAlgorithm(parameters.getSelectedSignature());
                this.session.setSendCertificateType(parameters.getSelectedServerCertificateType());
                CertificateType certificateType = parameters.getSelectedClientCertificateType();
                if (this.clientAuthenticationRequired || this.clientAuthenticationWanted && certificateType != null) {
                    this.session.setReceiveCertificateType(parameters.getSelectedClientCertificateType());
                }
            }
        } else {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client proposed unsupported cipher suites only", alert);
        }
        this.addServerHelloExtensions(cipherSuite, clientHello, serverHelloExtensions);
        this.session.setParameterAvailable();
        this.LOGGER.debug("Negotiated cipher suite [{}] with peer [{}]", (Object)cipherSuite.name(), (Object)this.getPeerAddress());
    }

    private void addServerHelloExtensions(CipherSuite negotiatedCipherSuite, ClientHello clientHello, HelloExtensions extensions) {
        CertificateTypeExtension ext;
        CertificateType certificateType = this.session.receiveCertificateType();
        if (certificateType != null && clientHello.getClientCertificateTypeExtension() != null) {
            ext = new ClientCertificateTypeExtension(certificateType);
            extensions.addExtension(ext);
        }
        if ((certificateType = this.session.sendCertificateType()) != null && clientHello.getServerCertificateTypeExtension() != null) {
            ext = new ServerCertificateTypeExtension(certificateType);
            extensions.addExtension(ext);
        }
        if (negotiatedCipherSuite.isEccBased() && clientHello.getSupportedPointFormatsExtension() != null) {
            extensions.addExtension(SupportedPointFormatsExtension.DEFAULT_POINT_FORMATS_EXTENSION);
        }
    }

    private List<XECDHECryptography.SupportedGroup> getCommonSupportedGroups(ClientHello clientHello) {
        ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>();
        SupportedEllipticCurvesExtension extension = clientHello.getSupportedEllipticCurvesExtension();
        if (extension == null) {
            groups.addAll(this.supportedGroups);
        } else {
            for (XECDHECryptography.SupportedGroup group : extension.getSupportedGroups()) {
                if (!this.supportedGroups.contains((Object)group)) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    private SupportedPointFormatsExtension.ECPointFormat negotiateECPointFormat(ClientHello clientHello) {
        SupportedPointFormatsExtension extension = clientHello.getSupportedPointFormatsExtension();
        if (extension == null) {
            return SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED;
        }
        if (extension.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            return SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED;
        }
        return null;
    }

    private List<SignatureAndHashAlgorithm> getCommonSignatureAndHashAlgorithms(ClientHello clientHello) {
        SignatureAlgorithmsExtension extension = clientHello.getSupportedSignatureAlgorithms();
        if (extension == null) {
            ArrayList<SignatureAndHashAlgorithm> signatures = new ArrayList<SignatureAndHashAlgorithm>();
            signatures.addAll(this.supportedSignatureAndHashAlgorithms);
            return signatures;
        }
        return SignatureAndHashAlgorithm.getCommonSignatureAlgorithms(extension.getSupportedSignatureAndHashAlgorithms(), this.supportedSignatureAndHashAlgorithms);
    }

    private List<CipherSuite> getCommonCipherSuites(ClientHello clientHello) {
        List<CipherSuite> supported = this.supportedCipherSuites;
        CipherSuite sessionCipherSuite = this.session.getCipherSuite();
        if (!sessionCipherSuite.equals((Object)CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
            supported = Arrays.asList(sessionCipherSuite);
        }
        ArrayList<CipherSuite> common = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : clientHello.getCipherSuites()) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !supported.contains((Object)cipherSuite)) continue;
            common.add(cipherSuite);
        }
        return common;
    }

    private List<CertificateType> getCommonClientCertificateTypes(ClientHello clientHello) {
        List<CertificateType> supported = this.supportedClientCertificateTypes;
        Principal principal = this.session.getPeerIdentity();
        if (principal != null) {
            supported = new ArrayList<CertificateType>();
            if (principal instanceof RawPublicKeyIdentity) {
                supported.add(CertificateType.RAW_PUBLIC_KEY);
            } else if (principal instanceof X509CertPath) {
                supported.add(CertificateType.X_509);
            }
        }
        return ServerHandshaker.getCommonCertificateTypes(clientHello.getClientCertificateTypeExtension(), supported);
    }

    private List<CertificateType> getCommonServerCertificateTypes(ClientHello clientHello) {
        return ServerHandshaker.getCommonCertificateTypes(clientHello.getServerCertificateTypeExtension(), this.supportedServerCertificateTypes);
    }

    private static List<CertificateType> getCommonCertificateTypes(CertificateTypeExtension certTypeExt, List<CertificateType> supportedCertificateTypes) {
        ArrayList<CertificateType> common = new ArrayList<CertificateType>();
        if (supportedCertificateTypes != null) {
            if (certTypeExt != null) {
                for (CertificateType certType : certTypeExt.getCertificateTypes()) {
                    if (!supportedCertificateTypes.contains((Object)certType)) continue;
                    common.add(certType);
                }
            } else if (supportedCertificateTypes.contains((Object)CertificateType.X_509)) {
                common.add(CertificateType.X_509);
            }
        }
        return common;
    }

    final CertificateType getNegotiatedClientCertificateType() {
        return this.selectedCipherSuiteParameters == null ? null : this.selectedCipherSuiteParameters.getSelectedClientCertificateType();
    }

    final CertificateType getNegotiatedServerCertificateType() {
        return this.selectedCipherSuiteParameters == null ? null : this.selectedCipherSuiteParameters.getSelectedServerCertificateType();
    }

    final XECDHECryptography.SupportedGroup getNegotiatedSupportedGroup() {
        return this.selectedCipherSuiteParameters == null ? null : this.selectedCipherSuiteParameters.getSelectedSupportedGroup();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.ecdhe);
        this.ecdhe = null;
    }
}

