/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CoAPEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = "coaps+tcp:uri";
    private static final String[] SCHEMES = new String[]{"coap", "coaps", "coap+tcp", "coaps+tcp"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "uri", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(15);
        props.add("recommendedCipherSuitesOnly");
        props.add("trustedRpkStore");
        props.add("sslContextParameters");
        props.add("exchangePattern");
        props.add("publicKey");
        props.add("uri");
        props.add("privateKey");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("cipherSuites");
        props.add("pskStore");
        props.add("alias");
        props.add("clientAuthentication");
        props.add("coapMethodRestrict");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

