/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class AddressEndpointContext
implements EndpointContext {
    protected static final int ID_TRUNC_LENGTH = 10;
    private final InetSocketAddress peerAddress;
    private final Principal peerIdentity;
    private final String virtualHost;

    public AddressEndpointContext(InetAddress address, int port) {
        if (address == null) {
            throw new NullPointerException("missing peer inet address!");
        }
        this.peerAddress = new InetSocketAddress(address, port);
        this.peerIdentity = null;
        this.virtualHost = null;
    }

    public AddressEndpointContext(InetSocketAddress peerAddress) {
        this(peerAddress, null, null);
    }

    public AddressEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity) {
        this(peerAddress, null, peerIdentity);
    }

    public AddressEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity) {
        if (peerAddress == null) {
            throw new NullPointerException("missing peer socket address, must not be null!");
        }
        this.peerAddress = peerAddress;
        this.virtualHost = virtualHost == null ? null : virtualHost.toLowerCase();
        this.peerIdentity = peerIdentity;
    }

    @Override
    public String get(String key) {
        return null;
    }

    @Override
    public Map<String, String> entries() {
        return Collections.emptyMap();
    }

    @Override
    public boolean hasCriticalEntries() {
        return false;
    }

    @Override
    public final Principal getPeerIdentity() {
        return this.peerIdentity;
    }

    @Override
    public final InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    @Override
    public final String getVirtualHost() {
        return this.virtualHost;
    }

    public String toString() {
        return String.format("IP(%s)", this.getPeerAddressAsString());
    }

    protected final String getPeerAddressAsString() {
        return StringUtil.toString(this.peerAddress);
    }
}

