/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    protected CamelLogger logger;
    protected RedeliveryPolicy redeliveryPolicy;
    protected Processor onRedelivery;
    protected Predicate retryWhile;
    protected String retryWhileRef;
    protected Processor failureProcessor;
    protected Endpoint deadLetter;
    protected String deadLetterUri;
    protected boolean deadLetterHandleNewException = true;
    protected boolean useOriginalMessage;
    protected boolean useOriginalBody;
    protected boolean asyncDelayedRedelivery;
    protected String executorServiceRef;
    protected ScheduledExecutorService executorService;
    protected Processor onPrepareFailure;
    protected Processor onExceptionOccurred;

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        DefaultErrorHandlerBuilder answer = new DefaultErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(DefaultErrorHandlerBuilder other) {
        super.cloneBuilder(other);
        if (this.logger != null) {
            other.setLogger(this.logger);
        }
        if (this.redeliveryPolicy != null) {
            other.setRedeliveryPolicy(this.redeliveryPolicy.copy());
        }
        if (this.onRedelivery != null) {
            other.setOnRedelivery(this.onRedelivery);
        }
        if (this.retryWhile != null) {
            other.setRetryWhile(this.retryWhile);
        }
        if (this.retryWhileRef != null) {
            other.setRetryWhileRef(this.retryWhileRef);
        }
        if (this.failureProcessor != null) {
            other.setFailureProcessor(this.failureProcessor);
        }
        if (this.deadLetter != null) {
            other.setDeadLetter(this.deadLetter);
        }
        if (this.deadLetterUri != null) {
            other.setDeadLetterUri(this.deadLetterUri);
        }
        if (this.onPrepareFailure != null) {
            other.setOnPrepareFailure(this.onPrepareFailure);
        }
        if (this.onExceptionOccurred != null) {
            other.setOnExceptionOccurred(this.onExceptionOccurred);
        }
        other.setDeadLetterHandleNewException(this.deadLetterHandleNewException);
        other.setUseOriginalMessage(this.useOriginalMessage);
        other.setUseOriginalBody(this.useOriginalBody);
        other.setAsyncDelayedRedelivery(this.asyncDelayedRedelivery);
        other.setExecutorServiceRef(this.executorServiceRef);
    }

    public DefaultErrorHandlerBuilder backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public DefaultErrorHandlerBuilder collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public DefaultErrorHandlerBuilder redeliveryDelay(long delay) {
        this.getRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public DefaultErrorHandlerBuilder delayPattern(String delayPattern) {
        this.getRedeliveryPolicy().delayPattern(delayPattern);
        return this;
    }

    public DefaultErrorHandlerBuilder maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public DefaultErrorHandlerBuilder disableRedelivery() {
        this.getRedeliveryPolicy().maximumRedeliveries(0);
        return this;
    }

    public DefaultErrorHandlerBuilder maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public DefaultErrorHandlerBuilder useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public DefaultErrorHandlerBuilder useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public DefaultErrorHandlerBuilder retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getRedeliveryPolicy().setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public DefaultErrorHandlerBuilder retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getRedeliveryPolicy().setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public DefaultErrorHandlerBuilder retryAttemptedLogInterval(int retryAttemptedLogInterval) {
        this.getRedeliveryPolicy().setRetryAttemptedLogInterval(retryAttemptedLogInterval);
        return this;
    }

    public DefaultErrorHandlerBuilder logStackTrace(boolean logStackTrace) {
        this.getRedeliveryPolicy().setLogStackTrace(logStackTrace);
        return this;
    }

    public DefaultErrorHandlerBuilder logRetryStackTrace(boolean logRetryStackTrace) {
        this.getRedeliveryPolicy().setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public DefaultErrorHandlerBuilder logHandled(boolean logHandled) {
        this.getRedeliveryPolicy().setLogHandled(logHandled);
        return this;
    }

    public DefaultErrorHandlerBuilder logNewException(boolean logNewException) {
        this.getRedeliveryPolicy().setLogNewException(logNewException);
        return this;
    }

    public DefaultErrorHandlerBuilder logExhausted(boolean logExhausted) {
        this.getRedeliveryPolicy().setLogExhausted(logExhausted);
        return this;
    }

    public DefaultErrorHandlerBuilder logRetryAttempted(boolean logRetryAttempted) {
        this.getRedeliveryPolicy().setLogRetryAttempted(logRetryAttempted);
        return this;
    }

    public DefaultErrorHandlerBuilder logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.getRedeliveryPolicy().setLogExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public DefaultErrorHandlerBuilder logExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.getRedeliveryPolicy().setLogExhaustedMessageBody(Boolean.valueOf(logExhaustedMessageBody));
        return this;
    }

    public DefaultErrorHandlerBuilder exchangeFormatterRef(String exchangeFormatterRef) {
        this.getRedeliveryPolicy().setExchangeFormatterRef(exchangeFormatterRef);
        return this;
    }

    public DefaultErrorHandlerBuilder asyncDelayedRedelivery() {
        this.getRedeliveryPolicy().setAsyncDelayedRedelivery(true);
        return this;
    }

    public DefaultErrorHandlerBuilder allowRedeliveryWhileStopping(boolean allowRedeliveryWhileStopping) {
        this.getRedeliveryPolicy().setAllowRedeliveryWhileStopping(allowRedeliveryWhileStopping);
        return this;
    }

    public DefaultErrorHandlerBuilder executorServiceRef(String ref) {
        this.setExecutorServiceRef(ref);
        return this;
    }

    public DefaultErrorHandlerBuilder logger(CamelLogger logger) {
        this.setLogger(logger);
        return this;
    }

    public DefaultErrorHandlerBuilder loggingLevel(LoggingLevel level) {
        this.getLogger().setLevel(level);
        return this;
    }

    public DefaultErrorHandlerBuilder log(Logger log) {
        this.getLogger().setLog(log);
        return this;
    }

    public DefaultErrorHandlerBuilder log(String log) {
        return this.log(LoggerFactory.getLogger((String)log));
    }

    public DefaultErrorHandlerBuilder log(Class<?> log) {
        return this.log(LoggerFactory.getLogger(log));
    }

    public DefaultErrorHandlerBuilder onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    public DefaultErrorHandlerBuilder retryWhile(Expression retryWhile) {
        this.setRetryWhile(ExpressionToPredicateAdapter.toPredicate((Expression)retryWhile));
        return this;
    }

    public DefaultErrorHandlerBuilder useOriginalMessage() {
        this.setUseOriginalMessage(true);
        return this;
    }

    public DefaultErrorHandlerBuilder useOriginalBody() {
        this.setUseOriginalBody(true);
        return this;
    }

    public DefaultErrorHandlerBuilder deadLetterHandleNewException(boolean handleNewException) {
        this.setDeadLetterHandleNewException(handleNewException);
        return this;
    }

    public DefaultErrorHandlerBuilder onPrepareFailure(Processor processor) {
        this.setOnPrepareFailure(processor);
        return this;
    }

    public DefaultErrorHandlerBuilder onExceptionOccurred(Processor processor) {
        this.setOnExceptionOccurred(processor);
        return this;
    }

    public Processor getFailureProcessor() {
        return this.failureProcessor;
    }

    public void setFailureProcessor(Processor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = this.createRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public CamelLogger getLogger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    public void setLogger(CamelLogger logger) {
        this.logger = logger;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    public Predicate getRetryWhilePolicy(CamelContext context) {
        Predicate answer = this.getRetryWhile();
        if (this.getRetryWhileRef() != null) {
            Language bean = context.resolveLanguage("bean");
            answer = bean.createPredicate(this.getRetryWhileRef());
        }
        return answer;
    }

    public Predicate getRetryWhile() {
        return this.retryWhile;
    }

    public void setRetryWhile(Predicate retryWhile) {
        this.retryWhile = retryWhile;
    }

    public String getRetryWhileRef() {
        return this.retryWhileRef;
    }

    public void setRetryWhileRef(String retryWhileRef) {
        this.retryWhileRef = retryWhileRef;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetter = null;
        this.deadLetterUri = deadLetterUri;
    }

    public Endpoint getDeadLetter() {
        return this.deadLetter;
    }

    public void setDeadLetter(Endpoint deadLetter) {
        this.deadLetter = deadLetter;
        this.deadLetterUri = deadLetter.getEndpointUri();
    }

    public boolean isDeadLetterHandleNewException() {
        return this.deadLetterHandleNewException;
    }

    public void setDeadLetterHandleNewException(boolean deadLetterHandleNewException) {
        this.deadLetterHandleNewException = deadLetterHandleNewException;
    }

    public boolean isUseOriginalMessage() {
        return this.useOriginalMessage;
    }

    public void setUseOriginalMessage(boolean useOriginalMessage) {
        this.useOriginalMessage = useOriginalMessage;
    }

    public boolean isUseOriginalBody() {
        return this.useOriginalBody;
    }

    public void setUseOriginalBody(boolean useOriginalBody) {
        this.useOriginalBody = useOriginalBody;
    }

    public boolean isAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(boolean asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Processor getOnPrepareFailure() {
        return this.onPrepareFailure;
    }

    public void setOnPrepareFailure(Processor onPrepareFailure) {
        this.onPrepareFailure = onPrepareFailure;
    }

    public Processor getOnExceptionOccurred() {
        return this.onExceptionOccurred;
    }

    public void setOnExceptionOccurred(Processor onExceptionOccurred) {
        this.onExceptionOccurred = onExceptionOccurred;
    }

    protected RedeliveryPolicy createRedeliveryPolicy() {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.disableRedelivery();
        return policy;
    }

    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(DefaultErrorHandler.class), LoggingLevel.ERROR);
    }

    public String toString() {
        return "DefaultErrorHandlerBuilder";
    }
}

