/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.InMemoryConnectionStore;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugConnectionStore
extends InMemoryConnectionStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)DebugConnectionStore.class.getName());

    public DebugConnectionStore(int capacity, long threshold, SessionCache sessionCache) {
        super(capacity, threshold, sessionCache);
    }

    public synchronized void dump() {
        if (this.connections.size() == 0) {
            LOG.info("  {}connections empty!", (Object)this.tag);
        } else {
            for (Connection connection : this.connections.values()) {
                this.dump(connection);
            }
        }
    }

    public boolean dump(InetSocketAddress address) {
        if (this.connections.size() == 0) {
            LOG.info("  {}connections empty!", (Object)this.tag);
        } else {
            Connection connection = this.get(address);
            if (connection == null) {
                LOG.info("  {}connection: {} - not available!", (Object)this.tag, (Object)address);
            } else {
                this.dump(connection);
                return true;
            }
        }
        return false;
    }

    private void dump(Connection connection) {
        if (connection.hasEstablishedSession()) {
            LOG.info("  {}connection: {} - {} : {}", new Object[]{this.tag, connection.getConnectionId(), connection.getPeerAddress(), connection.getEstablishedSession().getSessionIdentifier()});
        } else {
            LOG.info("  {}connection: {} - {}", new Object[]{this.tag, connection.getConnectionId(), connection.getPeerAddress()});
        }
    }

    public synchronized void validate() {
        StringBuilder failure = new StringBuilder();
        if (this.connections.size() == 0) {
            if (!this.connectionsByAddress.isEmpty()) {
                LOG.warn("  {}connections by address not empty!", (Object)this.tag);
                this.dump(this.connectionsByAddress);
                failure.append(" connections by address not empty!");
            }
            if (!this.connectionsByEstablishedSession.isEmpty()) {
                LOG.warn("  {}connections by session not empty!", (Object)this.tag);
                this.dump(this.connectionsByEstablishedSession);
                failure.append(" connections by sessions not empty!");
            }
        } else {
            Connection connection;
            for (Connection connection2 : this.connections.values()) {
                Connection peerConnection;
                InetSocketAddress peerAddress = connection2.getPeerAddress();
                if (peerAddress == null || connection2 == (peerConnection = (Connection)this.connectionsByAddress.get(peerAddress)) || peerConnection.equalsPeerAddress(peerAddress)) continue;
                LOG.warn("  {}connections mixed up peer {} - {} {}", new Object[]{this.tag, peerAddress, connection2, peerConnection});
                failure.append(" connections by sessions mixed up!");
            }
            for (InetSocketAddress peerAddress : this.connectionsByAddress.keySet()) {
                if (!peerAddress.equals((connection = (Connection)this.connectionsByAddress.get(peerAddress)).getPeerAddress())) {
                    LOG.warn("  {}connections by address mixed up {} - {}", new Object[]{this.tag, peerAddress, connection});
                    failure.append(" connections by address mixed up!");
                }
                if (this.connections.get((Object)connection.getConnectionId()) != null) continue;
                LOG.warn("  {}connections by address not available by cid! {} - {}", new Object[]{this.tag, peerAddress, connection});
                failure.append(" connections by address mixed up!");
            }
            for (SessionId session : this.connectionsByEstablishedSession.keySet()) {
                if (!session.equals((Object)(connection = (Connection)this.connectionsByEstablishedSession.get((Object)session)).getEstablishedSession().getSessionIdentifier())) {
                    LOG.warn("  {}connections by session mixed up {} - {}", new Object[]{this.tag, session, connection.getEstablishedSession().getSessionIdentifier()});
                    failure.append(" connections by session mixed up!");
                }
                if (this.connections.get((Object)connection.getConnectionId()) != null) continue;
                LOG.warn("  {}connections by session not available by cid! {} - {}", new Object[]{this.tag, session, connection});
                failure.append(" connections by session mixed up!");
            }
        }
        if (failure.length() > 0) {
            throw new IllegalStateException(this.tag + failure);
        }
    }

    private <K> void dump(ConcurrentMap<K, Connection> map) {
        for (Object key : map.keySet()) {
            Connection connection = (Connection)map.get(key);
            LOG.warn("  {} connection: {} - {}", new Object[]{this.tag, key, connection});
        }
    }
}

