/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.apicurio.registry.client.RegistryRestClient;
import io.apicurio.registry.client.request.HeadersInterceptor;
import io.apicurio.registry.client.request.RequestHandler;
import io.apicurio.registry.client.service.ArtifactsService;
import io.apicurio.registry.client.service.IdsService;
import io.apicurio.registry.client.service.RulesService;
import io.apicurio.registry.client.service.SearchService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class RegistryRestClientImpl
implements RegistryRestClient {
    private final Retrofit retrofit;
    private final RequestHandler requestHandler;
    private ArtifactsService artifactsService;
    private RulesService rulesService;
    private SearchService searchService;
    private IdsService idsService;

    RegistryRestClientImpl(String baseUrl) {
        this(baseUrl, Collections.emptyMap());
    }

    RegistryRestClientImpl(String baseUrl, Map<String, Object> config) {
        this(baseUrl, RegistryRestClientImpl.createHttpClientWithConfig(baseUrl, config));
    }

    RegistryRestClientImpl(String baseUrl, OkHttpClient okHttpClient) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.retrofit = new Retrofit.Builder().client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).baseUrl(baseUrl).build();
        this.requestHandler = new RequestHandler();
        this.initServices(this.retrofit);
    }

    private static OkHttpClient createHttpClientWithConfig(String baseUrl, Map<String, Object> configs) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder = RegistryRestClientImpl.addHeaders(okHttpClientBuilder, baseUrl, configs);
        okHttpClientBuilder = RegistryRestClientImpl.addSSL(okHttpClientBuilder, configs);
        return okHttpClientBuilder.build();
    }

    private static OkHttpClient.Builder addHeaders(OkHttpClient.Builder okHttpClientBuilder, String baseUrl, Map<String, Object> configs) {
        Map<String, String> requestHeaders = configs.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith("apicurio.registry.request.headers.")).collect(Collectors.toMap(map -> ((String)map.getKey()).replace("apicurio.registry.request.headers.", ""), map -> map.getValue().toString()));
        if (!requestHeaders.containsKey("Authorization")) {
            HttpUrl url = HttpUrl.parse((String)baseUrl);
            String user = url.encodedUsername();
            String pwd = url.encodedPassword();
            if (user != null && !user.isEmpty()) {
                String credentials = Credentials.basic((String)user, (String)pwd);
                requestHeaders.put("Authorization", credentials);
            }
        }
        if (!requestHeaders.isEmpty()) {
            HeadersInterceptor headersInterceptor = new HeadersInterceptor(requestHeaders);
            return okHttpClientBuilder.addInterceptor((Interceptor)headersInterceptor);
        }
        return okHttpClientBuilder;
    }

    private static OkHttpClient.Builder addSSL(OkHttpClient.Builder okHttpClientBuilder, Map<String, Object> configs) {
        try {
            KeyManager[] keyManagers = RegistryRestClientImpl.getKeyManagers(configs);
            Object[] trustManagers = RegistryRestClientImpl.getTrustManagers(configs);
            if (!(trustManagers == null || trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("A single X509TrustManager is expected. Unexpected trust managers: " + Arrays.toString(trustManagers));
            }
            if (keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(keyManagers, (TrustManager[])trustManagers, new SecureRandom());
                return okHttpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
            }
            return okHttpClientBuilder;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static TrustManager[] getTrustManagers(Map<String, Object> configs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        TrustManager[] trustManagers = null;
        if (configs.containsKey("apicurio.registry.request.ssl.truststore.location")) {
            String truststoreType = (String)configs.getOrDefault("apicurio.registry.request.ssl.truststore.type", "JKS");
            KeyStore truststore = KeyStore.getInstance(truststoreType);
            String truststorePwd = (String)configs.getOrDefault("apicurio.registry.request.ssl.truststore.password", "");
            truststore.load(new FileInputStream((String)configs.get("apicurio.registry.request.ssl.truststore.location")), truststorePwd.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        return trustManagers;
    }

    private static KeyManager[] getKeyManagers(Map<String, Object> configs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        if (configs.containsKey("apicurio.registry.request.ssl.keystore.location")) {
            String keystoreType = (String)configs.getOrDefault("apicurio.registry.request.ssl.keystore.type", "JKS");
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            String keyStorePwd = (String)configs.getOrDefault("apicurio.registry.request.ssl.keystore.password", "");
            keystore.load(new FileInputStream((String)configs.get("apicurio.registry.request.ssl.keystore.location")), keyStorePwd.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyPwd = (String)configs.getOrDefault("apicurio.registry.request.ssl.key.password", keyStorePwd);
            keyManagerFactory.init(keystore, keyPwd.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        return keyManagers;
    }

    private void initServices(Retrofit retrofit) {
        this.artifactsService = (ArtifactsService)retrofit.create(ArtifactsService.class);
        this.rulesService = (RulesService)retrofit.create(RulesService.class);
        this.idsService = (IdsService)retrofit.create(IdsService.class);
        this.searchService = (SearchService)retrofit.create(SearchService.class);
    }

    @Override
    public List<String> listArtifacts() {
        return this.requestHandler.execute(this.artifactsService.listArtifacts());
    }

    @Override
    public ArtifactMetaData createArtifact(String artifactId, ArtifactType artifactType, IfExistsType ifExistsType, InputStream data) {
        return this.requestHandler.execute(this.artifactsService.createArtifact(artifactType, artifactId, ifExistsType, RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])IoUtil.toBytes((InputStream)data))));
    }

    @Override
    public InputStream getLatestArtifact(String artifactId) {
        return this.requestHandler.execute(this.artifactsService.getLatestArtifact(artifactId)).byteStream();
    }

    @Override
    public ArtifactMetaData updateArtifact(String artifactId, ArtifactType artifactType, InputStream data) {
        return this.requestHandler.execute(this.artifactsService.updateArtifact(artifactId, artifactType, RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])IoUtil.toBytes((InputStream)data))));
    }

    @Override
    public void deleteArtifact(String artifactId) {
        this.requestHandler.execute(this.artifactsService.deleteArtifact(artifactId));
    }

    @Override
    public void updateArtifactState(String artifactId, UpdateState data) {
        this.requestHandler.execute(this.artifactsService.updateArtifactState(artifactId, data));
    }

    @Override
    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        return this.requestHandler.execute(this.artifactsService.getArtifactMetaData(artifactId));
    }

    @Override
    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        this.requestHandler.execute(this.artifactsService.updateArtifactMetaData(artifactId, data));
    }

    @Override
    public ArtifactMetaData getArtifactMetaDataByContent(String artifactId, InputStream data) {
        return this.requestHandler.execute(this.artifactsService.getArtifactMetaDataByContent(artifactId, RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])IoUtil.toBytes((InputStream)data))));
    }

    @Override
    public List<Long> listArtifactVersions(String artifactId) {
        return this.requestHandler.execute(this.artifactsService.listArtifactVersions(artifactId));
    }

    @Override
    public VersionMetaData createArtifactVersion(String artifactId, ArtifactType artifactType, InputStream data) {
        return this.requestHandler.execute(this.artifactsService.createArtifactVersion(artifactId, artifactType, RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])IoUtil.toBytes((InputStream)data))));
    }

    @Override
    public InputStream getArtifactVersion(String artifactId, Integer version) {
        return this.requestHandler.execute(this.artifactsService.getArtifactVersion(version, artifactId)).byteStream();
    }

    @Override
    public void updateArtifactVersionState(String artifactId, Integer version, UpdateState data) {
        this.requestHandler.execute(this.artifactsService.updateArtifactVersionState(version, artifactId, data));
    }

    @Override
    public VersionMetaData getArtifactVersionMetaData(String artifactId, Integer version) {
        return this.requestHandler.execute(this.artifactsService.getArtifactVersionMetaData(version, artifactId));
    }

    @Override
    public void updateArtifactVersionMetaData(String artifactId, Integer version, EditableMetaData data) {
        this.requestHandler.execute(this.artifactsService.updateArtifactVersionMetaData(version, artifactId, data));
    }

    @Override
    public void deleteArtifactVersionMetaData(String artifactId, Integer version) {
        this.requestHandler.execute(this.artifactsService.deleteArtifactVersionMetaData(version, artifactId));
    }

    @Override
    public List<RuleType> listArtifactRules(String artifactId) {
        return this.requestHandler.execute(this.artifactsService.listArtifactRules(artifactId));
    }

    @Override
    public void createArtifactRule(String artifactId, Rule data) {
        this.requestHandler.execute(this.artifactsService.createArtifactRule(artifactId, data));
    }

    @Override
    public void deleteArtifactRules(String artifactId) {
        this.requestHandler.execute(this.artifactsService.deleteArtifactRules(artifactId));
    }

    @Override
    public Rule getArtifactRuleConfig(String artifactId, RuleType rule) {
        return this.requestHandler.execute(this.artifactsService.getArtifactRuleConfig(rule, artifactId));
    }

    @Override
    public Rule updateArtifactRuleConfig(String artifactId, RuleType rule, Rule data) {
        return this.requestHandler.execute(this.artifactsService.updateArtifactRuleConfig(rule, artifactId, data));
    }

    @Override
    public void deleteArtifactRule(String artifactId, RuleType rule) {
        this.requestHandler.execute(this.artifactsService.deleteArtifactRule(rule, artifactId));
    }

    @Override
    public void testUpdateArtifact(String artifactId, ArtifactType artifactType, InputStream data) {
        this.requestHandler.execute(this.artifactsService.testUpdateArtifact(artifactId, artifactType, RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])IoUtil.toBytes((InputStream)data))));
    }

    @Override
    public InputStream getArtifactByGlobalId(long globalId) {
        return this.requestHandler.execute(this.idsService.getArtifactByGlobalId(globalId)).byteStream();
    }

    @Override
    public ArtifactMetaData getArtifactMetaDataByGlobalId(long globalId) {
        return this.requestHandler.execute(this.idsService.getArtifactMetaDataByGlobalId(globalId));
    }

    @Override
    public ArtifactSearchResults searchArtifacts(String search, SearchOver over, SortOrder order, Integer offset, Integer limit) {
        return this.requestHandler.execute(this.searchService.searchArtifacts(search, offset, limit, over, order));
    }

    @Override
    public VersionSearchResults searchVersions(String artifactId, Integer offset, Integer limit) {
        return this.requestHandler.execute(this.searchService.searchVersions(artifactId, offset, limit));
    }

    @Override
    public Rule getGlobalRuleConfig(RuleType rule) {
        return this.requestHandler.execute(this.rulesService.getGlobalRuleConfig(rule));
    }

    @Override
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        return this.requestHandler.execute(this.rulesService.updateGlobalRuleConfig(rule, data));
    }

    @Override
    public void deleteGlobalRule(RuleType rule) {
        this.requestHandler.execute(this.rulesService.deleteGlobalRule(rule));
    }

    @Override
    public List<RuleType> listGlobalRules() {
        return this.requestHandler.execute(this.rulesService.listGlobalRules());
    }

    @Override
    public void createGlobalRule(Rule data) {
        this.requestHandler.execute(this.rulesService.createGlobalRule(data));
    }

    @Override
    public void deleteAllGlobalRules() {
        this.requestHandler.execute(this.rulesService.deleteAllGlobalRules());
    }
}

