/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.Stringable;

public abstract class AvroSchemaHelper {
    private static final ObjectMapper DEFAULT_VALUE_MAPPER = new ObjectMapper();
    public static final String AVRO_SCHEMA_PROP_CLASS = "java-class";
    public static final String AVRO_SCHEMA_PROP_KEY_CLASS = "java-key-class";
    public static final String AVRO_SCHEMA_PROP_ELEMENT_CLASS = "java-element-class";
    protected static final Set<Class<?>> STRINGABLE_CLASSES = new HashSet<Class>(Arrays.asList(URI.class, URL.class, File.class, BigInteger.class, BigDecimal.class, String.class));

    public static boolean isStringable(AnnotatedClass type) {
        if (STRINGABLE_CLASSES.contains(type.getRawType()) || Enum.class.isAssignableFrom(type.getRawType())) {
            return true;
        }
        if (type.getAnnotated().getAnnotation(Stringable.class) == null) {
            return false;
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (constructor.getParameterCount() != 1 || constructor.getRawParameterType(0) != String.class) continue;
            return true;
        }
        return false;
    }

    protected static String getNamespace(JavaType type) {
        return AvroSchemaHelper.getNamespace(type.getRawClass());
    }

    protected static String getNamespace(Class<?> cls) {
        Class<?> enclosing = cls.getEnclosingClass();
        if (enclosing != null) {
            return enclosing.getName() + "$";
        }
        Package pkg = cls.getPackage();
        return pkg == null ? "" : pkg.getName();
    }

    protected static String getName(JavaType type) {
        return AvroSchemaHelper.getName(type.getRawClass());
    }

    protected static String getName(Class<?> cls) {
        String name = cls.getSimpleName();
        while (name.indexOf("[]") >= 0) {
            name = name.replace("[]", "Array");
        }
        return name;
    }

    protected static Schema unionWithNull(Schema otherSchema) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        if (otherSchema.getType() == Schema.Type.UNION) {
            schemas.addAll(otherSchema.getTypes());
        } else {
            schemas.add(otherSchema);
        }
        return Schema.createUnion(schemas);
    }

    public static Schema simpleSchema(JsonFormatTypes type, JavaType hint) {
        switch (type) {
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case INTEGER: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case NULL: {
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case NUMBER: {
                if (hint.hasRawClass(Float.TYPE)) {
                    return Schema.create((Schema.Type)Schema.Type.FLOAT);
                }
                if (hint.hasRawClass(Long.TYPE)) {
                    return Schema.create((Schema.Type)Schema.Type.LONG);
                }
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case STRING: {
                if (hint != null && hint.hasRawClass(UUID.class)) {
                    return AvroSchemaHelper.createUUIDSchema();
                }
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case ARRAY: 
            case OBJECT: {
                throw new UnsupportedOperationException("Should not try to create simple Schema for: " + type);
            }
        }
        throw new UnsupportedOperationException("Can not create Schema for: " + type + "; not (yet) supported");
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type) {
        switch (type) {
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case LONG: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
        }
        throw new IllegalStateException("Unrecognized number type: " + type);
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type, JavaType hint) {
        Schema schema = AvroSchemaHelper.numericAvroSchema(type);
        if (hint != null) {
            schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(hint));
        }
        return schema;
    }

    public static Schema typedSchema(Schema.Type nativeType, JavaType javaType) {
        Schema schema = Schema.create((Schema.Type)nativeType);
        schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(javaType));
        return schema;
    }

    public static Schema anyNumberSchema() {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.DOUBLE)));
    }

    public static Schema stringableKeyMapSchema(JavaType mapType, JavaType keyType, Schema valueSchema) {
        Schema schema = Schema.createMap((Schema)valueSchema);
        if (mapType != null && !mapType.hasRawClass(Map.class)) {
            schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(mapType));
        }
        if (keyType != null && !keyType.hasRawClass(String.class)) {
            schema.addProp(AVRO_SCHEMA_PROP_KEY_CLASS, AvroSchemaHelper.getTypeId(keyType));
        }
        return schema;
    }

    protected static <T> T throwUnsupported() {
        throw new UnsupportedOperationException("Format variation not supported");
    }

    public static Schema initializeRecordSchema(BeanDescription bean) {
        return AvroSchemaHelper.addAlias(Schema.createRecord((String)AvroSchemaHelper.getName(bean.getType()), (String)bean.findClassDescription(), (String)AvroSchemaHelper.getNamespace(bean.getType()), (boolean)bean.getType().isTypeOrSubTypeOf(Throwable.class)), bean);
    }

    public static Schema parseJsonSchema(String json) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(json);
    }

    public static Schema createEnumSchema(BeanDescription bean, List<String> values) {
        return AvroSchemaHelper.addAlias(Schema.createEnum((String)AvroSchemaHelper.getName(bean.getType()), (String)bean.findClassDescription(), (String)AvroSchemaHelper.getNamespace(bean.getType()), values), bean);
    }

    public static Schema createUUIDSchema() {
        return Schema.createFixed((String)"UUID", (String)"", (String)"java.util", (int)16);
    }

    public static Schema addAlias(Schema schema, BeanDescription bean) {
        AvroAlias ann = (AvroAlias)bean.getClassInfo().getAnnotation(AvroAlias.class);
        if (ann != null) {
            schema.addAlias(ann.alias(), ann.space().equals("NOT A VALID NAMESPACE") ? null : ann.space());
        }
        return schema;
    }

    public static String getTypeId(JavaType type) {
        return AvroSchemaHelper.getTypeId(type.getRawClass());
    }

    public static String getTypeId(Class<?> type) {
        if (type.isPrimitive()) {
            return ClassUtil.wrapperType(type).getName();
        }
        return type.getName();
    }

    public static String getTypeId(Schema schema) {
        switch (schema.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return AvroSchemaHelper.getFullName(schema);
            }
        }
        return schema.getProp(AVRO_SCHEMA_PROP_CLASS);
    }

    public static String getFullName(Schema schema) {
        Schema.Type type = schema.getType();
        switch (type) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                String namespace = schema.getNamespace();
                String name = schema.getName();
                if (namespace == null) {
                    return name;
                }
                int len = namespace.length();
                if (namespace.charAt(len - 1) == '$') {
                    return namespace + name;
                }
                return FullNameResolver.instance.resolve(namespace, name);
            }
        }
        return type.getName();
    }

    public static JsonNode nullNode() {
        return DEFAULT_VALUE_MAPPER.nullNode();
    }

    public static JsonNode objectToJsonNode(Object defaultValue) {
        if (defaultValue == JsonProperties.NULL_VALUE) {
            return AvroSchemaHelper.nullNode();
        }
        return (JsonNode)DEFAULT_VALUE_MAPPER.convertValue(defaultValue, JsonNode.class);
    }

    public static Object jsonNodeToObject(JsonNode defaultJsonValue) {
        if (defaultJsonValue == null) {
            return null;
        }
        if (defaultJsonValue.isNull()) {
            return JsonProperties.NULL_VALUE;
        }
        return DEFAULT_VALUE_MAPPER.convertValue((Object)defaultJsonValue, Object.class);
    }

    public static JsonNode parseDefaultValue(String defaultValue) throws JsonMappingException {
        if (defaultValue == null) {
            return null;
        }
        try {
            return DEFAULT_VALUE_MAPPER.readTree(defaultValue);
        }
        catch (JsonProcessingException e) {
            if (e instanceof JsonMappingException) {
                throw (JsonMappingException)e;
            }
            throw new JsonMappingException(null, "Failed to parse default value", (Throwable)e);
        }
    }

    private static final class FullNameKey {
        private final String _namespace;
        private final String _name;
        private final int _hashCode;

        public FullNameKey(String namespace, String name) {
            this._namespace = namespace;
            this._name = name;
            this._hashCode = namespace.hashCode() + name.hashCode();
        }

        public String nameWithSeparator(char sep) {
            StringBuilder sb = new StringBuilder(1 + this._namespace.length() + this._name.length());
            return sb.append(this._namespace).append(sep).append(this._name).toString();
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            FullNameKey other = (FullNameKey)o;
            return other._name.equals(this._name) && other._namespace.equals(this._namespace);
        }
    }

    private static final class FullNameResolver {
        private final LRUMap<FullNameKey, String> SCHEMA_NAME_CACHE = new LRUMap(80, 800);
        public static final FullNameResolver instance = new FullNameResolver();

        private FullNameResolver() {
        }

        public String resolve(String namespace, String name) {
            FullNameKey cacheKey = new FullNameKey(namespace, name);
            String schemaName = (String)this.SCHEMA_NAME_CACHE.get((Object)cacheKey);
            if (schemaName == null) {
                schemaName = FullNameResolver._resolve(cacheKey);
                this.SCHEMA_NAME_CACHE.put((Object)cacheKey, (Object)schemaName);
            }
            return schemaName;
        }

        private static String _resolve(FullNameKey key) {
            String nestedClassName = key.nameWithSeparator('$');
            try {
                Class.forName(nestedClassName);
                return nestedClassName;
            }
            catch (ClassNotFoundException e) {
                return key.nameWithSeparator('.');
            }
        }
    }
}

