/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.util;

import com.worldturner.util.ByteArraySource;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/worldturner/util/RepeatingByteArrayInputStream;", "Ljava/io/InputStream;", "source", "", "repeats", "", "([BI)V", "sources", "", "Lcom/worldturner/util/ByteArraySource;", "(Ljava/util/List;)V", "current", "iterator", "", "position", "repeat", "advanceCurrent", "", "available", "checkPosition", "close", "read", "destination", "destinationOffset", "length", "skip", "", "n", "medeia-validator-core"})
public final class RepeatingByteArrayInputStream
extends InputStream {
    private final Iterator<ByteArraySource> iterator;
    private ByteArraySource current;
    private int position;
    private int repeat;

    private final void checkPosition() {
        block3: {
            ByteArraySource byteArraySource;
            ByteArraySource byteArraySource2 = this.current;
            if (byteArraySource2 == null) break block3;
            ByteArraySource current = byteArraySource = byteArraySource2;
            boolean bl = false;
            if (this.position >= current.getSource().length) {
                int n = this.repeat;
                this.repeat = n + 1;
                if (this.repeat >= current.getRepeats()) {
                    this.advanceCurrent();
                } else {
                    this.position = 0;
                }
            }
        }
    }

    private final void advanceCurrent() {
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        this.repeat = 0;
        this.position = 0;
    }

    @Override
    public int read() {
        this.checkPosition();
        ByteArraySource byteArraySource = this.current;
        if (byteArraySource != null) {
            ByteArraySource byteArraySource2;
            ByteArraySource current = byteArraySource2 = byteArraySource;
            boolean bl = false;
            int n = this.position;
            this.position = n + 1;
            return current.getSource()[n] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] destination, int destinationOffset, int length) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        if (destinationOffset < 0 || length < 0 || length > destination.length - destinationOffset) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        this.checkPosition();
        ByteArraySource byteArraySource = this.current;
        if (byteArraySource != null) {
            ByteArraySource byteArraySource2;
            ByteArraySource current = byteArraySource2 = byteArraySource;
            boolean bl = false;
            int n2 = length;
            int n3 = current.getSource().length - this.position;
            int actualLength = Math.min(n2, n3);
            if (length <= 0) {
                n = 0;
            } else {
                ArraysKt.copyInto((byte[])current.getSource(), (byte[])destination, (int)destinationOffset, (int)this.position, (int)(this.position + actualLength));
                this.position += actualLength;
                n = actualLength;
            }
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public long skip(long n) {
        long l;
        this.checkPosition();
        ByteArraySource byteArraySource = this.current;
        if (byteArraySource != null) {
            ByteArraySource byteArraySource2;
            ByteArraySource current = byteArraySource2 = byteArraySource;
            boolean bl = false;
            long l2 = 0L;
            long l3 = n;
            l2 = Math.max(l2, l3);
            l3 = Integer.MAX_VALUE;
            long limited = Math.min(l2, l3);
            int n2 = (int)limited;
            int n3 = current.getSource().length - this.position;
            int skipLength = Math.min(n2, n3);
            this.position += skipLength;
            l = skipLength;
        } else {
            l = -1L;
        }
        return l;
    }

    @Override
    public int available() {
        int n;
        ByteArraySource byteArraySource = this.current;
        if (byteArraySource != null) {
            ByteArraySource byteArraySource2;
            ByteArraySource current = byteArraySource2 = byteArraySource;
            boolean bl = false;
            n = current.getSource().length - this.position;
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void close() {
    }

    public RepeatingByteArrayInputStream(@NotNull List<ByteArraySource> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.iterator = sources.iterator();
        this.advanceCurrent();
    }

    public RepeatingByteArrayInputStream(@NotNull byte[] source, int repeats) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this(CollectionsKt.listOf((Object)new ByteArraySource(source, repeats)));
    }
}

