/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.providers;

import com.x5.template.ContentSource;
import com.x5.template.Snippet;
import com.x5.template.TemplateDoc;
import java.io.IOException;
import java.util.HashMap;

public abstract class TemplateProvider
implements ContentSource {
    private static String DEFAULT_EXTENSION = "chtml";
    private static String DEFAULT_ENCODING = "UTF-8";
    private String extension = DEFAULT_EXTENSION;
    private String encoding = DEFAULT_ENCODING;
    HashMap<String, Snippet> snippetCache = new HashMap();

    public String fetch(String templateName) {
        Snippet s = this.getSnippet(templateName);
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    public boolean provides(String itemName) {
        Snippet x = this.getSnippet(itemName);
        return x != null;
    }

    public abstract String getProtocol();

    public Snippet getSnippet(String templateName) {
        if (this.snippetCache.containsKey(templateName)) {
            return this.snippetCache.get(templateName);
        }
        String rawTemplate = null;
        try {
            rawTemplate = this.loadItemDoc(templateName);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        if (rawTemplate == null) {
            this.snippetCache.put(templateName, null);
            return null;
        }
        TemplateDoc doc = new TemplateDoc(templateName, rawTemplate);
        try {
            return this.parseSnippet(doc, templateName);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Snippet parseSnippet(TemplateDoc doc, String snippetName) throws IOException {
        Snippet r = null;
        for (TemplateDoc.Doclet doclet : doc.parseTemplates(this.encoding)) {
            String templateKey = doclet.getName();
            Snippet s = doclet.getSnippet();
            if (templateKey.equals(snippetName)) {
                r = s;
            }
            this.snippetCache.put(templateKey, s);
        }
        return r;
    }

    public String loadItemDoc(String itemName) throws IOException {
        return this.loadContainerDoc(this.resourceName(itemName));
    }

    public abstract String loadContainerDoc(String var1) throws IOException;

    private String resourceName(String itemName) {
        String ext = this.extension;
        String embeddedExtension = this.parseEmbeddedExtension(itemName);
        if (embeddedExtension != null) {
            itemName = itemName.substring(embeddedExtension.length() + 2);
            ext = embeddedExtension;
        }
        int hashPos = itemName.indexOf(35);
        if (ext == null || ext.length() < 1) {
            if (hashPos < 0) {
                return itemName;
            }
            return itemName.substring(0, hashPos);
        }
        if (hashPos < 0) {
            return itemName + '.' + ext;
        }
        String filename = itemName.substring(0, hashPos) + '.' + ext;
        return filename;
    }

    private String parseEmbeddedExtension(String itemName) {
        if (itemName.charAt(0) != ';') {
            return null;
        }
        int endColonPos = itemName.indexOf(59, 1);
        if (endColonPos < 0) {
            return null;
        }
        return itemName.substring(1, endColonPos);
    }

    public void clearCache() {
        this.snippetCache.clear();
    }

    public void clearCache(String itemName) {
        this.snippetCache.remove(itemName);
    }

    public void setDefaultExtension(String ext) {
        this.extension = ext;
    }
}

