/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.InlineTable;
import com.x5.template.Snippet;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.RegexFilter;
import com.x5.util.DataCapsule;
import com.x5.util.TableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    public static String FILTER_FIRST = "FILTER_FIRST";
    public static String FILTER_LAST = "FILTER_LAST";
    private static Map<String, ChunkFilter> filters = Filter.registerStockFilters();
    private FilterArgs filterArgs;
    private ChunkFilter filter;
    private boolean isSafe = false;
    private static final Pattern parsePattern = Pattern.compile("includeIf\\(([\\!\\~])(.*)\\)\\.?([^\\)]*)$");
    private static final Pattern parsePatternAlt = Pattern.compile("include\\.\\(([\\!\\~])(.*)\\)([^\\)]*)$");

    private static Map<String, ChunkFilter> registerStockFilters() {
        if (filters == null) {
            filters = BasicFilter.getStockFilters();
        }
        return filters;
    }

    public static Object applyFilter(Chunk context, String filter, Object input) {
        if (filter == null) {
            return input;
        }
        return Filter.applyFilter(context, Filter.parseFilterChain(filter), input);
    }

    public static Object applyFilter(Chunk context, Filter[] filters, Object input) {
        if (filters == null) {
            return input;
        }
        Object filtered = input;
        for (int i = 0; i < filters.length; ++i) {
            filtered = filters[i].apply(context, filtered);
        }
        return filtered;
    }

    public static Filter[] parseFilterChain(String filter) {
        if (filter == null) {
            return null;
        }
        String[] filters = Filter.splitFilters(filter);
        Filter[] parsedFilters = new Filter[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            parsedFilters[i] = new Filter(filters[i]);
        }
        return parsedFilters;
    }

    public Filter(String filter) {
        this.filterArgs = new FilterArgs(filter);
    }

    public Object apply(Chunk context, Object input) {
        ChunkFilter stockFilter;
        ChunkFilter userFilter;
        if (this.filter != null) {
            if (this.isSafe) {
                return this.filter.applyFilter(context, input, this.filterArgs);
            }
            try {
                return this.filter.applyFilter(context, input, this.filterArgs);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return input;
            }
        }
        String filterName = this.filterArgs.getFilterName();
        Map<String, ChunkFilter> customFilters = null;
        ChunkFactory userTheme = context.getChunkFactory();
        if (userTheme != null) {
            customFilters = userTheme.getFilters();
        }
        if (customFilters != null && (userFilter = customFilters.get(filterName)) != null) {
            this.filter = userFilter;
            return this.apply(context, input);
        }
        String rawFilter = this.filterArgs.getUnparsedFilter();
        if (rawFilter.equals("type")) {
            return Filter.typeFilter(context, input);
        }
        String text = this.inputAsText(input);
        if (text != null) {
            TableData array;
            if (rawFilter.equals("trim")) {
                return text.trim();
            }
            if (rawFilter.startsWith("join(")) {
                array = InlineTable.parseTable(text);
                if (array != null) {
                    return Filter.joinInlineTable(array, this.filterArgs);
                }
            } else if (rawFilter.startsWith("get(") && (array = InlineTable.parseTable(text)) != null) {
                return Filter.accessArrayIndex(array, this.filterArgs);
            }
        }
        if ((stockFilter = filters.get(filterName)) != null) {
            this.filter = stockFilter;
            this.isSafe = true;
            return this.apply(context, input);
        }
        return input;
    }

    private String inputAsText(Object input) {
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof Snippet) {
            return ((Snippet)input).toSimpleString();
        }
        return null;
    }

    public static String[] splitFilters(String filter) {
        int startOfNext = Filter.findNextFilter(filter);
        if (startOfNext < 0) {
            return new String[]{filter};
        }
        ArrayList<String> filterList = new ArrayList<String>();
        while (startOfNext >= 0) {
            filterList.add(filter.substring(0, startOfNext));
            filter = filter.substring(startOfNext + 1);
            startOfNext = Filter.findNextFilter(filter);
        }
        filterList.add(filter);
        String[] filters = new String[filterList.size()];
        return filterList.toArray(filters);
    }

    private static int findNextFilter(String filter) {
        int pipePos = filter.indexOf(124);
        if (pipePos >= 0 && filter.startsWith("s/")) {
            int regexEnd = RegexFilter.nextRegexDelim(filter, 2);
            if (regexEnd < 0) {
                return pipePos;
            }
            if ((regexEnd = RegexFilter.nextRegexDelim(filter, regexEnd + 1)) < 0) {
                return pipePos;
            }
            if (regexEnd < pipePos) {
                return pipePos;
            }
            return filter.indexOf("|", regexEnd + 1);
        }
        if (pipePos >= 0 && filter.startsWith("onmatch")) {
            int closeParen;
            int openParen;
            int commaPos;
            int slashPos;
            boolean skippedArgs = false;
            int cursor = 8;
            while (!skippedArgs && (slashPos = filter.indexOf("/", cursor)) >= 0 && (slashPos = RegexFilter.nextRegexDelim(filter, slashPos + 1)) >= 0 && (commaPos = FilterArgs.nextUnescapedDelim(",", filter, slashPos + 1)) >= 0) {
                int moreArgs = FilterArgs.nextUnescapedDelim(",", filter, commaPos + 1);
                if (moreArgs < 0) {
                    int closeParen2 = FilterArgs.nextUnescapedDelim(")", filter, commaPos + 1);
                    if (closeParen2 < 0) break;
                    if (filter.length() > closeParen2 + 8 && filter.substring(closeParen2 + 1, closeParen2 + 8).equals("nomatch")) {
                        cursor = closeParen2 + 1;
                        skippedArgs = true;
                        continue;
                    }
                    pipePos = filter.indexOf("|", closeParen2 + 1);
                    return pipePos;
                }
                cursor = moreArgs + 1;
            }
            if ((openParen = filter.indexOf("(", cursor)) > 0 && (closeParen = FilterArgs.nextUnescapedDelim(")", filter, openParen + 1)) > 0) {
                pipePos = filter.indexOf("|", closeParen + 1);
                return pipePos;
            }
            pipePos = filter.indexOf("|", cursor);
            return pipePos;
        }
        return pipePos;
    }

    public static String translateIncludeIf(String tag, String open, String close, Map<String, Object> tagTable) {
        Matcher parseMatcher = parsePattern.matcher(tag);
        if (!parseMatcher.find() && !(parseMatcher = parsePatternAlt.matcher(tag)).find()) {
            return "[includeIf bad syntax: " + tag + "]";
        }
        parseMatcher.group(0);
        String negater = parseMatcher.group(1);
        String test = parseMatcher.group(2);
        String includeTemplate = parseMatcher.group(3);
        includeTemplate = includeTemplate.replaceAll("[\\|:].*$", "");
        if (test.indexOf(61) < 0 && test.indexOf("!~") < 0) {
            if (negater.charAt(0) == '~') {
                return open + test + "|ondefined(+" + includeTemplate + "):" + close;
            }
            return open + test + "|ondefined():+" + includeTemplate + close;
        }
        boolean isNeg = false;
        if (test.indexOf("==") > 0 || (isNeg = test.indexOf("!=") > 0)) {
            String[] parts = test.split("!=|==");
            if (parts.length == 2) {
                String xlation;
                String tagA = parts[0].trim();
                String tagB = parts[1].trim();
                if (tagB.charAt(0) == '~') {
                    String tagValue = null;
                    Object tagValueObj = tagTable.get(tagA);
                    if (tagValueObj != null) {
                        tagValue = tagValueObj.toString();
                    }
                    if (tagValue == null) {
                        tagValue = "";
                    }
                    xlation = isNeg ? open + tagB.substring(1) + "|onmatch(/^" + RegexFilter.escapeRegex(tagValue) + "$/,)nomatch(+" + includeTemplate + ")" + close : open + tagB.substring(1) + "|onmatch(/^" + RegexFilter.escapeRegex(tagValue) + "$/,+" + includeTemplate + ")nomatch()" + close;
                } else {
                    String match = tagB;
                    if (tagB.charAt(0) == '\"' && tagB.charAt(match.length() - 1) == '\"') {
                        match = tagB.substring(1, tagB.length() - 1);
                    }
                    xlation = isNeg ? open + tagA + "|onmatch(/^" + RegexFilter.escapeRegex(match) + "$/,)nomatch(+" + includeTemplate + ")" + close : open + tagA + "|onmatch(/^" + RegexFilter.escapeRegex(match) + "$/,+" + includeTemplate + ")nomatch()" + close;
                }
                return xlation;
            }
            return "[includeIf bad syntax: " + tag + "]";
        }
        String[] parts = test.split("=~");
        boolean neg = false;
        if (parts.length != 2) {
            parts = test.split("!~");
            neg = true;
            if (parts.length != 2) {
                return "[includeIf bad syntax: " + tag + "]";
            }
        }
        String var = parts[0].trim();
        String match = parts[1].trim();
        String xlation = neg ? open + var + "|onmatch(" + match + ",)nomatch(+" + includeTemplate + ")" + close : open + var + "|onmatch(" + match + ",+" + includeTemplate + ")nomatch()" + close;
        return xlation;
    }

    public static int grokFinalFilterPipe(String wholeTag, int startHere) {
        int cursor = startHere;
        String filter = wholeTag.substring(cursor + 1);
        int startOfNext = Filter.findNextFilter(filter);
        while (startOfNext >= 0) {
            ++cursor;
            cursor += startOfNext;
            startOfNext = Filter.findNextFilter(filter.substring(startOfNext + 1));
        }
        return cursor;
    }

    public static String accessArrayIndex(TableData table, FilterArgs getFilter) {
        return Filter.accessArrayIndex(Filter.extractListFromTable(table), getFilter);
    }

    public static String accessArrayIndex(String[] array, FilterArgs getFilter) {
        if (array == null) {
            return "";
        }
        return Filter.accessArrayIndex(Arrays.asList(array), getFilter);
    }

    public static String accessArrayIndex(List<String> list, FilterArgs getFilter) {
        if (list == null) {
            return "";
        }
        String[] args = getFilter.getFilterArgs();
        if (args != null) {
            String idx = args[0];
            try {
                int x = Integer.parseInt(idx);
                if (x < 0) {
                    x = list.size() + x;
                }
                if (x >= 0 && x < list.size()) {
                    return list.get(x);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "";
    }

    private static List<String> extractListFromTable(TableData table) {
        if (table == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (table.hasNext()) {
            table.nextRecord();
            String[] record = table.getRow();
            list.add(record[0]);
        }
        return list;
    }

    public static String joinInlineTable(TableData table, FilterArgs joinFilter) {
        return Filter.joinStringList(Filter.extractListFromTable(table), joinFilter);
    }

    public static String joinStringArray(String[] array, FilterArgs joinFilter) {
        if (array == null) {
            return "";
        }
        if (array.length == 1) {
            return array[0];
        }
        return Filter.joinStringList(Arrays.asList(array), joinFilter);
    }

    public static String joinStringList(List<String> list, FilterArgs joinFilter) {
        if (list == null) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        String divider = joinFilter.getUnparsedArgs();
        StringBuilder x = new StringBuilder();
        int i = 0;
        for (String s : list) {
            if (i > 0 && divider != null) {
                x.append(divider);
            }
            if (s != null) {
                x.append(s);
            }
            ++i;
        }
        return x.toString();
    }

    public static String typeFilter(Chunk context, Object tagValue) {
        return Filter._typeFilter(context, tagValue, 0);
    }

    private static String _typeFilter(Chunk context, Object tagValue, int depth) {
        if (depth > 7) {
            return "CIRCULAR_POINTER";
        }
        if (tagValue == null) {
            return "NULL";
        }
        if (tagValue instanceof String) {
            if (Filter.isInlineTable((String)tagValue)) {
                return "LIST";
            }
            return "STRING";
        }
        if (tagValue instanceof Snippet) {
            if (Filter.isInlineTable(tagValue.toString())) {
                return "LIST";
            }
            Snippet snippet = (Snippet)tagValue;
            if (snippet.isSimplePointer()) {
                String tagRef = snippet.getPointer();
                return Filter._typeFilter(context, context.get(tagRef), depth + 1);
            }
            return "STRING";
        }
        if (tagValue instanceof Chunk) {
            return "CHUNK";
        }
        if (tagValue instanceof String[] || tagValue instanceof List || tagValue instanceof Object[] || tagValue instanceof TableData) {
            return "LIST";
        }
        if (tagValue instanceof Map || tagValue instanceof DataCapsule) {
            return "OBJECT";
        }
        return "UNKNOWN";
    }

    private static boolean isInlineTable(String value) {
        TableData inlineTable = InlineTable.parseTable(value);
        return inlineTable != null;
    }

    public static String resolveBackticks(Chunk chunk, String tagName) {
        return chunk.resolveBackticks(tagName, 0);
    }
}

