/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.Filter;
import com.x5.template.IfTag;
import com.x5.template.LocaleTag;
import com.x5.template.LoopTag;
import com.x5.template.MacroTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.RegexFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;

public class SnippetTag
extends SnippetPart {
    protected String tag;
    private String[] path;
    private boolean hasBackticks;
    private Filter[] filters;
    private String ifNull;
    private boolean applyFiltersIfNull = false;
    private static final BlockTag[] BLOCK_TAGS = new BlockTag[]{new LoopTag(), new IfTag(), new LocaleTag(), new MacroTag()};
    private static final String[] BLOCK_TAG_TOKENS = SnippetTag.extractTagTokens(BLOCK_TAGS);

    public SnippetTag(String text, String tag) {
        super(text);
        this.tag = tag;
    }

    public boolean isTag() {
        return true;
    }

    public String getTag() {
        return this.tag;
    }

    public void render(Writer out, Chunk rules, String origin, int depth) throws IOException {
        if (this.depthCheckFails(depth, out)) {
            return;
        }
        Object tagValue = null;
        if (this.path == null) {
            this.init();
        }
        if ((tagValue = rules.resolveTagValue(this, depth, origin)) == null) {
            out.append(this.snippetText);
        } else if (tagValue instanceof Snippet) {
            ((Snippet)tagValue).render(out, rules, depth);
        } else if (tagValue instanceof String) {
            Snippet compiled = Snippet.getSnippet((String)tagValue, origin);
            compiled.render(out, rules, depth + 1);
        } else {
            rules.explodeToPrinter(out, tagValue, depth + 1);
        }
    }

    private int[][] findBacktickSpans() {
        int maxTicks = 10;
        int[] allTicks = new int[maxTicks];
        int tick = 0;
        int tagLen = this.tag.length();
        for (int i = 0; i < tagLen && tick < maxTicks; ++i) {
            char c = this.tag.charAt(i);
            if (c != '`') continue;
            allTicks[tick] = i;
            ++tick;
        }
        if (tick == 0) {
            return null;
        }
        int[][] spans = new int[(tick + 1) / 2][];
        for (int i = 0; i < (tick + 1) / 2; ++i) {
            spans[i] = new int[]{allTicks[i * 2], allTicks[i * 2 + 1]};
        }
        return spans;
    }

    private int[] getMatchingSpan(int[][] spans, int index) {
        if (spans == null) {
            return null;
        }
        for (int[] span : spans) {
            int spanStart = span[0];
            int spanEnd = span[1];
            if (index < spanStart || spanEnd != 0 && index >= spanEnd) continue;
            return span;
        }
        return null;
    }

    private int findCharacterOutsideSpans(String searchSpace, int[][] offLimits, char c) {
        int[] span;
        int pos = searchSpace.indexOf(c);
        if (pos < 0) {
            return pos;
        }
        while (pos > -1 && (span = this.getMatchingSpan(offLimits, pos)) != null) {
            int spanEnd = span[1];
            if (spanEnd == 0) {
                return -1;
            }
            pos = searchSpace.indexOf(c, spanEnd + 1);
        }
        return pos;
    }

    private void init() {
        int[][] backtickSpans = this.findBacktickSpans();
        String lookupName = this.tag;
        int colonPos = this.findCharacterOutsideSpans(lookupName, backtickSpans, ':');
        int pipePos = this.findCharacterOutsideSpans(lookupName, backtickSpans, '|');
        if (pipePos > -1) {
            pipePos = this.confirmPipe(this.tag, pipePos);
        }
        if (colonPos > 0 || pipePos > 0) {
            int firstMod;
            int n = firstMod = colonPos > 0 ? colonPos : pipePos;
            if (pipePos > 0 && pipePos < colonPos) {
                firstMod = pipePos;
            }
            lookupName = this.tag.substring(0, firstMod);
            String defValue = null;
            String filter = null;
            String order = Filter.FILTER_LAST;
            if (pipePos > 0 && colonPos > 0) {
                String[] tokens = this.parseTagTokens(this.tag, pipePos, colonPos);
                filter = tokens[0];
                defValue = tokens[1];
                order = tokens[2];
            } else if (colonPos > 0) {
                defValue = this.tag.substring(colonPos + 1);
            } else {
                filter = this.tag.substring(pipePos + 1);
            }
            this.ifNull = defValue;
            this.applyFiltersIfNull = order.equals(Filter.FILTER_LAST);
            this.filters = Filter.parseFilterChain(filter);
        }
        this.path = this.parsePath(lookupName);
    }

    private String[] parsePath(String deepRef) {
        if (deepRef.indexOf("`") > -1) {
            this.hasBackticks = true;
        }
        if (deepRef.indexOf(46, 1) < 0 || deepRef.charAt(0) == '.') {
            return new String[]{deepRef};
        }
        StringTokenizer splitter = new StringTokenizer(deepRef, ".");
        int segmentCount = splitter.countTokens();
        String[] path = new String[segmentCount];
        int i = 0;
        while (splitter.hasMoreTokens()) {
            path[i] = splitter.nextToken();
            ++i;
        }
        return path;
    }

    private String[] parseTagTokens(String tagName, int pipePos, int colonPos) {
        String filter = null;
        String defValue = null;
        String order = Filter.FILTER_LAST;
        if (colonPos < 0) {
            filter = tagName.substring(pipePos + 1);
        } else if (pipePos < colonPos) {
            int finalPipe = Filter.grokFinalFilterPipe(tagName, pipePos);
            int nextColon = tagName.indexOf(":", finalPipe + 1);
            if (nextColon < 0) {
                filter = tagName.substring(pipePos + 1);
            } else {
                int startScan = FilterArgs.grokValidColonScanPoint(tagName, finalPipe + 1);
                nextColon = tagName.indexOf(":", startScan);
                if (nextColon < 0) {
                    filter = tagName.substring(pipePos + 1);
                } else {
                    filter = tagName.substring(pipePos + 1, nextColon);
                    defValue = tagName.substring(nextColon + 1);
                    order = Filter.FILTER_FIRST;
                }
            }
        } else {
            filter = tagName.substring(pipePos + 1);
            defValue = tagName.substring(colonPos + 1, pipePos);
        }
        return new String[]{filter, defValue, order};
    }

    private int confirmPipe(String tagName, int pipePos) {
        String skipToken = "includeIf(";
        String closeToken = ")";
        int doesntCountParen = tagName.indexOf(skipToken);
        if (doesntCountParen < 0 && (doesntCountParen = tagName.indexOf(skipToken = "include.(")) < 0) {
            skipToken = "`";
            closeToken = "`";
            doesntCountParen = tagName.indexOf(skipToken);
        }
        if (doesntCountParen < 0 || doesntCountParen > pipePos) {
            return pipePos;
        }
        int scanFrom = doesntCountParen + skipToken.length();
        int nextParen = tagName.indexOf(closeToken, scanFrom);
        if (closeToken.equals("`")) {
            if (pipePos > nextParen) {
                return pipePos;
            }
        } else {
            int nextSlash = tagName.indexOf("/", scanFrom);
            if (nextSlash < 0 || nextParen < 0) {
                return pipePos;
            }
            if (nextParen < nextSlash) {
                return pipePos;
            }
            int regexEnd = RegexFilter.nextRegexDelim(tagName, nextSlash + 1);
            nextParen = tagName.indexOf(")", regexEnd + 1);
            if (nextParen < 0 || nextParen < pipePos) {
                return pipePos;
            }
        }
        return tagName.indexOf("|", nextParen + 1);
    }

    public String[] getPath() {
        if (this.path == null) {
            this.init();
        }
        return this.path;
    }

    public boolean hasBackticks() {
        return this.hasBackticks;
    }

    public String getDefaultValue() {
        if (this.ifNull == null || this.ifNull.length() == 0) {
            return this.ifNull;
        }
        char firstChar = this.ifNull.charAt(0);
        if (firstChar == '~' || firstChar == '$' || firstChar == '+' || firstChar == '^' || firstChar == '.') {
            if (this.filters == null) {
                return '{' + this.ifNull + '}';
            }
            if (this.applyFiltersIfNull) {
                return '{' + this.ifNull + '|' + this.filters + '}';
            }
            return '{' + this.ifNull + '}';
        }
        if (this.ifNull.charAt(0) == '\\') {
            return this.ifNull.substring(1);
        }
        return this.ifNull;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public boolean applyFiltersFirst() {
        return !this.applyFiltersIfNull;
    }

    static SnippetTag parseTag(String tag) {
        SnippetTag parsedTag = new SnippetTag(tag, tag);
        parsedTag.init();
        return parsedTag;
    }

    private static String[] extractTagTokens(BlockTag[] blockTags) {
        String[] tokens = new String[blockTags.length];
        for (int i = 0; i < blockTags.length; ++i) {
            tokens[i] = "." + blockTags[i].getBlockStartMarker();
        }
        return tokens;
    }

    public BlockTag getBlockTagType() {
        for (int i = 0; i < BLOCK_TAG_TOKENS.length; ++i) {
            if (!this.tag.startsWith(BLOCK_TAG_TOKENS[i])) continue;
            if (BLOCK_TAGS[i].hasBody(this.tag)) {
                return BLOCK_TAGS[i];
            }
            return null;
        }
        return null;
    }
}

