/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.support.DefaultLRUCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LRUCacheFactory {
    public static final String FACTORY = "lru-cache-factory";
    private static final Logger LOG = LoggerFactory.getLogger(LRUCacheFactory.class);
    private static volatile LRUCacheFactory instance;

    public static void init() {
        if (instance == null) {
            instance = LRUCacheFactory.createLRUCacheFactory();
        }
    }

    public static void setLRUCacheFactory(LRUCacheFactory cacheFactory) {
        instance = cacheFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LRUCacheFactory getInstance() {
        if (instance != null) return instance;
        Class<LRUCacheFactory> clazz = LRUCacheFactory.class;
        synchronized (LRUCacheFactory.class) {
            if (instance != null) return instance;
            instance = LRUCacheFactory.createLRUCacheFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static LRUCacheFactory createLRUCacheFactory() {
        block9: {
            LOG.trace("createLRUCacheFactory");
            try {
                ClassLoader classLoader = LRUCacheFactory.class.getClassLoader();
                URL url = classLoader.getResource("META-INF/services/org/apache/camel/lru-cache-factory");
                if (url == null) break block9;
                Properties props = new Properties();
                try (InputStream is = url.openStream();){
                    props.load(is);
                }
                String clazzName = props.getProperty("class");
                if (clazzName != null) {
                    LOG.trace("Loading class: {}", (Object)clazzName);
                    Class<?> clazz = classLoader.loadClass(clazzName);
                    LOG.trace("Creating LRUCacheFactory instance from class: {}", (Object)clazzName);
                    Object factory = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    LOG.trace("Created LRUCacheFactory instance: {}", factory);
                    LOG.info("Detected and using LRUCacheFactory: {}", factory);
                    return (LRUCacheFactory)factory;
                }
            }
            catch (Throwable t) {
                LOG.warn("Error creating LRUCacheFactory. Will use DefaultLRUCacheFactory.", t);
            }
        }
        LOG.debug("Creating DefaultLRUCacheFactory");
        return new DefaultLRUCacheFactory();
    }

    public static <K, V> Map<K, V> newLRUCache(int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUCache(int maximumCacheSize, Consumer<V> onEvict) {
        return LRUCacheFactory.getInstance().createLRUCache(maximumCacheSize, onEvict);
    }

    public static <K, V> Map<K, V> newLRUCache(int initialCapacity, int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        return LRUCacheFactory.getInstance().createLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUSoftCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int initialCapacity, int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUSoftCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        return LRUCacheFactory.getInstance().createLRUSoftCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUWeakCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int initialCapacity, int maximumCacheSize) {
        return LRUCacheFactory.getInstance().createLRUWeakCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        return LRUCacheFactory.getInstance().createLRUWeakCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public abstract <K, V> Map<K, V> createLRUCache(int var1);

    public abstract <K, V> Map<K, V> createLRUCache(int var1, Consumer<V> var2);

    public abstract <K, V> Map<K, V> createLRUCache(int var1, int var2);

    public abstract <K, V> Map<K, V> createLRUCache(int var1, int var2, boolean var3);

    public abstract <K, V> Map<K, V> createLRUSoftCache(int var1);

    public abstract <K, V> Map<K, V> createLRUSoftCache(int var1, int var2);

    public abstract <K, V> Map<K, V> createLRUSoftCache(int var1, int var2, boolean var3);

    @Deprecated
    public abstract <K, V> Map<K, V> createLRUWeakCache(int var1);

    @Deprecated
    public abstract <K, V> Map<K, V> createLRUWeakCache(int var1, int var2);

    @Deprecated
    public abstract <K, V> Map<K, V> createLRUWeakCache(int var1, int var2, boolean var3);
}

