/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AnnotationModel {
    protected String className;
    protected List<AnnotationOptionModel> options = new ArrayList<AnnotationOptionModel>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<AnnotationOptionModel> getOptions() {
        return this.options;
    }

    public void addOption(AnnotationOptionModel option) {
        this.options.add(option);
    }

    public List<AnnotationOptionModel> getSortedOptions() {
        return this.options.stream().sorted((o1, o2) -> {
            if (o1.isOptional() == o2.isOptional()) {
                return o1.getName().compareTo(o2.getName());
            }
            return Boolean.compare(o1.isOptional(), o2.isOptional());
        }).collect(Collectors.toList());
    }

    public static class AnnotationOptionModel {
        protected String name;
        protected String type;
        protected String description;
        protected String defaultValue;
        protected boolean optional;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }
    }
}

