/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(LogProcessor.class);
    private String id;
    private String routeId;
    private final Expression expression;
    private final String message;
    private final CamelLogger logger;
    private final MaskingFormatter formatter;
    private final Set<LogListener> listeners;

    public LogProcessor(Expression expression, CamelLogger logger, MaskingFormatter formatter, Set<LogListener> listeners) {
        this.expression = expression;
        this.message = null;
        this.logger = logger;
        this.formatter = formatter;
        this.listeners = listeners;
    }

    public LogProcessor(String message, CamelLogger logger, MaskingFormatter formatter, Set<LogListener> listeners) {
        this.expression = null;
        this.message = message;
        this.logger = logger;
        this.formatter = formatter;
        this.listeners = listeners;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.logger.shouldLog()) {
            try {
                String msg = this.expression != null ? (String)this.expression.evaluate(exchange, String.class) : this.message;
                if (this.formatter != null) {
                    msg = this.formatter.format(msg);
                }
                if (this.listeners != null && !this.listeners.isEmpty()) {
                    msg = this.fireListeners(exchange, msg);
                }
                this.logger.doLog(msg);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
        }
        callback.done(true);
        return true;
    }

    private String fireListeners(Exchange exchange, String message) {
        for (LogListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                String output = listener.onLog(exchange, this.logger, message);
                message = output != null ? output : message;
            }
            catch (Throwable t) {
                LOG.warn("Ignoring an exception thrown by {}: {}", (Object)listener.getClass().getName(), (Object)t.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("", t);
            }
        }
        return message;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        if (this.expression != null) {
            return "log[" + this.expression + "]";
        }
        return "log[" + this.message + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getMessage() {
        return this.message;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    public MaskingFormatter getLogFormatter() {
        return this.formatter;
    }
}

