/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProcessor
extends AsyncProcessorSupport
implements Traceable,
EndpointAware,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SendProcessor.class);
    protected transient String traceLabelToString;
    protected final ExtendedCamelContext camelContext;
    protected final ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected AsyncProducer producer;
    protected Endpoint destination;
    protected ExchangePattern destinationExchangePattern;
    protected String id;
    protected String routeId;
    protected boolean extendedStatistics;
    protected final AtomicLong counter = new AtomicLong();

    public SendProcessor(Endpoint destination) {
        this(destination, null);
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        ObjectHelper.notNull((Object)destination, (String)"destination");
        this.destination = destination;
        this.camelContext = (ExtendedCamelContext)destination.getCamelContext();
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        this.pattern = pattern;
        this.destinationExchangePattern = null;
        this.destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl((String)destination.getEndpointUri());
    }

    public String toString() {
        return this.destination != null ? this.destination.toString() : this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTraceLabel() {
        if (this.traceLabelToString == null) {
            this.traceLabelToString = URISupport.sanitizeUri((String)this.destination.getEndpointUri());
        }
        return this.traceLabelToString;
    }

    public Endpoint getEndpoint() {
        return this.destination;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("SendProcessor has not been started: " + this));
            callback.done(true);
            return true;
        }
        ExchangePattern existingPattern = exchange.getPattern();
        if (this.extendedStatistics) {
            this.counter.incrementAndGet();
        }
        if (this.producer != null) {
            boolean newCallback;
            Exchange target = exchange;
            if (this.destinationExchangePattern != null || this.pattern != null) {
                target.setPattern(this.destinationExchangePattern != null ? this.destinationExchangePattern : this.pattern);
            }
            exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)this.destination.getEndpointUri());
            boolean sending = this.camelContext.isEventNotificationApplicable() && EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)target, (Endpoint)this.destination);
            StopWatch watch = sending ? new StopWatch() : null;
            AsyncCallback ac = callback;
            boolean bl = newCallback = watch != null || existingPattern != target.getPattern();
            if (newCallback) {
                ac = doneSync -> {
                    try {
                        target.setPattern(existingPattern);
                        if (watch != null) {
                            long timeTaken = watch.taken();
                            EventHelper.notifyExchangeSent((CamelContext)target.getContext(), (Exchange)target, (Endpoint)this.destination, (long)timeTaken);
                        }
                    }
                    finally {
                        callback.done(doneSync);
                    }
                };
            }
            try {
                LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
                boolean sync = this.producer.process(exchange, ac);
                if (!sync) {
                    EventHelper.notifyExchangeAsyncProcessingStartedEvent((CamelContext)exchange.getContext(), (Exchange)exchange);
                }
                return sync;
            }
            catch (Throwable throwable) {
                exchange.setException(throwable);
                callback.done(true);
                return true;
            }
        }
        if (this.destinationExchangePattern != null || this.pattern != null) {
            exchange.setPattern(this.destinationExchangePattern != null ? this.destinationExchangePattern : this.pattern);
        }
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)this.destination.getEndpointUri());
        LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
        return this.producerCache.doInAsyncProducer(this.destination, exchange, callback, (producer, ex, cb) -> producer.process(ex, doneSync -> {
            exchange.setPattern(existingPattern);
            cb.done(doneSync);
        }));
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void reset() {
        this.counter.set(0L);
    }

    protected void doInit() throws Exception {
        this.extendedStatistics = this.camelContext.getManagementStrategy() != null && this.camelContext.getManagementStrategy().getManagementAgent() != null ? this.camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
        if (!this.destination.isSingletonProducer() && this.producerCache == null) {
            this.producerCache = new DefaultProducerCache((Object)this, (CamelContext)this.camelContext, 0);
        }
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.destination);
        if (this.destination.isSingletonProducer()) {
            this.producer = this.destination.createAsyncProducer();
            this.camelContext.addService((Object)this.producer, true, true);
        } else {
            ServiceHelper.startService((Object)this.producerCache);
        }
    }

    protected void doStop() throws Exception {
        if (this.producer != null) {
            this.camelContext.removeService((Object)this.producer);
        }
        ServiceHelper.stopService((Object[])new Object[]{this.producerCache, this.producer});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producerCache, this.producer});
    }
}

