/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.CollectionStringBuffer;

@Metadata(label="dataformat,transformation,json", title="JSon")
@XmlRootElement(name="json")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String objectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String useDefaultObjectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String prettyPrint;
    @XmlAttribute
    @Metadata(defaultValue="Jackson")
    private JsonLibrary library = JsonLibrary.Jackson;
    @XmlAttribute
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    private Class<?> jsonView;
    @XmlAttribute
    private String include;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowJmsType;
    @XmlAttribute
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useList;
    @XmlAttribute
    private String moduleClassNames;
    @XmlAttribute
    private String moduleRefs;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;
    @XmlAttribute
    private String permissions;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowUnmarshallType;
    @XmlAttribute
    private String timezone;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String autoDiscoverObjectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String dropRootNode;

    public JsonDataFormat() {
        super("json");
    }

    public JsonDataFormat(JsonLibrary library) {
        this.library = library;
    }

    public String getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public JsonLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(JsonLibrary library) {
        this.library = library;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
    }

    public String getUseList() {
        return this.useList;
    }

    public void setUseList(String useList) {
        this.useList = useList;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setPermissions(Class<?> ... type) {
        CollectionStringBuffer csb = new CollectionStringBuffer(",");
        for (Class<?> clazz : type) {
            csb.append((Object)"+");
            csb.append((Object)clazz.getName());
        }
        this.setPermissions(csb.toString());
    }

    public String getAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getAutoDiscoverObjectMapper() {
        return this.autoDiscoverObjectMapper;
    }

    public void setAutoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
    }

    public String getDropRootNode() {
        return this.dropRootNode;
    }

    public void setDropRootNode(String dropRootNode) {
        this.dropRootNode = dropRootNode;
    }

    @Override
    public String getDataFormatName() {
        return "json-" + this.library.name().toLowerCase();
    }

    public JsonDataFormat objectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public JsonDataFormat useDefaultObjectMapper(boolean useDefaultObjectMapper) {
        return this.useDefaultObjectMapper(Boolean.toString(useDefaultObjectMapper));
    }

    public JsonDataFormat useDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
        return this;
    }

    public JsonDataFormat prettyPrint(boolean prettyPrint) {
        return this.prettyPrint(Boolean.toString(prettyPrint));
    }

    public JsonDataFormat prettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public JsonDataFormat library(JsonLibrary library) {
        this.library = library;
        return this;
    }

    public JsonDataFormat unmarshalType(String unmarshalType) {
        this.unmarshalTypeName = unmarshalType;
        return this;
    }

    public JsonDataFormat unmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
        return this;
    }

    public JsonDataFormat jsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
        return this;
    }

    public JsonDataFormat include(String include) {
        this.include = include;
        return this;
    }

    public JsonDataFormat allowJmsType(boolean allowJmsType) {
        return this.allowJmsType(Boolean.toString(allowJmsType));
    }

    public JsonDataFormat allowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
        return this;
    }

    public JsonDataFormat collectionType(String collectionType) {
        this.collectionTypeName = collectionType;
        return this;
    }

    public JsonDataFormat collectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public JsonDataFormat useList(boolean useList) {
        return this.useList(Boolean.toString(useList));
    }

    public JsonDataFormat useList(String useList) {
        this.useList = useList;
        return this;
    }

    public JsonDataFormat moduleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
        return this;
    }

    public JsonDataFormat moduleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
        return this;
    }

    public JsonDataFormat enableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
        return this;
    }

    public JsonDataFormat disableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
        return this;
    }

    public JsonDataFormat permissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public JsonDataFormat allowUnmarshallType(boolean allowUnmarshallType) {
        return this.allowUnmarshallType(Boolean.toString(allowUnmarshallType));
    }

    public JsonDataFormat allowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
        return this;
    }

    public JsonDataFormat timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public JsonDataFormat autoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
        return this.autoDiscoverObjectMapper(Boolean.toString(autoDiscoverObjectMapper));
    }

    public JsonDataFormat autoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
        return this;
    }

    public JsonDataFormat dropRootNode(boolean dropRootNode) {
        return this.dropRootNode(Boolean.toString(dropRootNode));
    }

    public JsonDataFormat dropRootNode(String dropRootNode) {
        this.dropRootNode = dropRootNode;
        return this;
    }
}

