/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.api.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.api.MapBuilder;
import com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.fasterxml.jackson.jr.ob.impl.AnyReader;
import com.fasterxml.jackson.jr.ob.impl.ArrayReader;
import com.fasterxml.jackson.jr.ob.impl.CollectionReader;
import com.fasterxml.jackson.jr.ob.impl.MapReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReaderLocator;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JSONReader {
    protected final MapBuilder _mapBuilder;
    protected final CollectionBuilder _collectionBuilder;
    protected final int _features;
    protected final TreeCodec _treeCodec;
    protected final ValueReaderLocator _readerLocator;
    protected final JsonParser _parser;

    public JSONReader(CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        this._features = 0;
        this._readerLocator = null;
        this._treeCodec = null;
        this._collectionBuilder = collectionBuilder;
        this._mapBuilder = mapBuilder;
        this._parser = null;
    }

    protected JSONReader(JSONReader jSONReader, int n, ValueReaderLocator valueReaderLocator, TreeCodec treeCodec, JsonParser jsonParser) {
        this._features = n;
        this._readerLocator = valueReaderLocator.perOperationInstance(this, n);
        this._treeCodec = treeCodec;
        this._collectionBuilder = jSONReader._collectionBuilder.newBuilder(n);
        this._mapBuilder = jSONReader._mapBuilder.newBuilder(n);
        this._parser = jsonParser;
    }

    public JSONReader withCacheCheck(int n) {
        return this;
    }

    public JSONReader with(MapBuilder mapBuilder) {
        if (this._mapBuilder == mapBuilder) {
            return this;
        }
        return this._with(this._collectionBuilder, mapBuilder);
    }

    public JSONReader with(CollectionBuilder collectionBuilder) {
        if (this._collectionBuilder == collectionBuilder) {
            return this;
        }
        return this._with(collectionBuilder, this._mapBuilder);
    }

    protected JSONReader _with(CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override _with(...)");
        }
        return new JSONReader(collectionBuilder, mapBuilder);
    }

    public JSONReader perOperationInstance(int n, ValueReaderLocator valueReaderLocator, TreeCodec treeCodec, JsonParser jsonParser) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONReader(this, n, valueReaderLocator, treeCodec, jsonParser);
    }

    public boolean arraysAsLists() {
        return JSON.Feature.READ_JSON_ARRAYS_AS_JAVA_ARRAYS.isDisabled(this._features);
    }

    public boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public Object readValue() throws IOException {
        return AnyReader.std.read(this, this._parser);
    }

    public Map<String, Object> readMap() throws IOException {
        JsonToken jsonToken = this._parser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_OBJECT) {
            throw JSONObjectException.from(this._parser, "Can not read a Map: expect to see START_OBJECT ('{'), instead got: " + ValueReader._tokenDesc(this._parser));
        }
        return AnyReader.std.readFromObject(this, this._parser, this._mapBuilder);
    }

    public List<Object> readList() throws IOException {
        JsonToken jsonToken = this._parser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
        }
        return (List)AnyReader.std.readCollectionFromArray(this, this._parser, this._collectionBuilder);
    }

    public Object[] readArray() throws IOException {
        JsonToken jsonToken = this._parser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
        }
        return AnyReader.std.readArrayFromArray(this, this._parser, this._collectionBuilder);
    }

    public <T> T readBean(Class<T> clazz) throws IOException {
        Object object = this._readerLocator.findReader(clazz).read(this, this._parser);
        return (T)object;
    }

    public <T> T[] readArrayOf(Class<T> clazz) throws IOException {
        JsonToken jsonToken = this._parser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
        }
        return (Object[])new ArrayReader(clazz, clazz, this._readerLocator.findReader(clazz)).read(this, this._parser);
    }

    public <T> List<T> readListOf(Class<T> clazz) throws IOException {
        JsonToken jsonToken = this._parser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
        }
        return (List)new CollectionReader(List.class, this._readerLocator.findReader(clazz)).read(this, this._parser);
    }

    public <T> Map<String, T> readMapOf(Class<T> clazz) throws IOException {
        JsonToken jsonToken = this._parser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_OBJECT) {
            throw JSONObjectException.from(this._parser, "Can not read a Map: expect to see START_OBJECT ('{'), instead got: " + ValueReader._tokenDesc(this._parser));
        }
        return (Map)new MapReader(Map.class, this._readerLocator.findReader(clazz)).read(this, this._parser);
    }

    public TreeNode readTree() throws IOException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No `TreeCodec` specified: can not bind JSON into `TreeNode` types");
        }
        return this._treeCodec.readTree(this._parser);
    }

    protected MapBuilder _mapBuilder(Class<?> clazz) {
        return clazz == null ? this._mapBuilder : this._mapBuilder.newBuilder(clazz);
    }

    protected CollectionBuilder _collectionBuilder(Class<?> clazz) {
        return clazz == null ? this._collectionBuilder : this._collectionBuilder.newBuilder(clazz);
    }
}

