/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.utils.DateUtils;

public class UnixTimestampNanoSecondsDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getValueAsString();
        long valueWithMilliseconds = new BigDecimal(value).multiply(BigDecimal.valueOf(1000L)).longValue();
        return DateUtils.fromUnixTimeWithMilliseconds(valueWithMilliseconds);
    }
}

