/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.service.trade.params;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamInstrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamMultiCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamMultiInstrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsIdSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;

public class TradeHistoryParamsAll
implements TradeHistoryParamsTimeSpan,
TradeHistoryParamPaging,
TradeHistoryParamsIdSpan,
TradeHistoryParamOffset,
TradeHistoryParamCurrencyPair,
TradeHistoryParamMultiCurrencyPair,
TradeHistoryParamInstrument,
TradeHistoryParamMultiInstrument,
TradeHistoryParamLimit {
    private Integer pageLength;
    private Integer pageNumber;
    private String startId;
    private String endId;
    private Date startTime;
    private Date endTime;
    private Long offset;
    private Instrument instrument;
    private Collection<Instrument> instruments = Collections.emptySet();
    private Integer limit;

    @Override
    public Integer getPageLength() {
        return this.pageLength;
    }

    @Override
    public void setPageLength(Integer count) {
        this.pageLength = count;
    }

    @Override
    public String getStartId() {
        return this.startId;
    }

    @Override
    public void setStartId(String from) {
        this.startId = from;
    }

    @Override
    public String getEndId() {
        return this.endId;
    }

    @Override
    public void setEndId(String endId) {
        this.endId = endId;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date to) {
        this.endTime = to;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public Long getOffset() {
        if (this.offset != null || this.pageLength == null || this.pageNumber == null) {
            return this.offset;
        }
        return (long)this.pageLength.intValue() * (long)this.pageNumber.intValue();
    }

    @Override
    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @Override
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        if (this.instrument instanceof CurrencyPair) {
            return (CurrencyPair)this.instrument;
        }
        return null;
    }

    @Override
    public void setCurrencyPair(CurrencyPair pair) {
        this.instrument = pair;
    }

    @Override
    public Collection<CurrencyPair> getCurrencyPairs() {
        if (!this.instruments.isEmpty()) {
            return this.instruments.stream().filter(instrument -> instrument instanceof CurrencyPair).map(instrument -> (CurrencyPair)instrument).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public void setCurrencyPairs(Collection<CurrencyPair> value) {
        this.instruments = new HashSet<CurrencyPair>(value);
    }

    @Override
    public Instrument getInstrument() {
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    @Override
    public Collection<Instrument> getInstruments() {
        return this.instruments;
    }

    @Override
    public void setInstruments(Collection<Instrument> instruments) {
        this.instruments = instruments;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

